<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Nominee</title>
   @include('head')
</head>
<body>
@include('header-user')
  <section class="hero-section">
    <div class="container">
    

      <div class="row g-4 align-items-center">
         <div class="col-lg-2"></div>
      <div class="col-lg-8">

            <div class="stepper mb-4">
              <div class="step complete">
                  <div class="dot">✓</div>
                  <div>PAN Verification</div>
              </div>
              <div class="line active-line"></div>

              <div class="step complete">
                  <div class="dot">✓</div>
                  <div>Aadhar KYC</div>
              </div>
              <div class="line active-line"></div>

              <div class="step">
                  <div class="dot">✓</div>
                  <div>Personal Info</div>
              </div>
              <div class="line active-line"></div>

              <div class="step">
                  <div class="dot">✓</div>
                  <div>Webcame</div>
              </div>
              <div class="line active-line"></div>

              <div class="step">
                  <div class="dot inactive"> <div style="background-color: #f0a100; width: 6px;  height: 6px; border-radius: 50%;"></div></div>
                  <div class="active-text">Add Nominee</div>
              </div>
          </div>

          <div class="signup-card">
            

            <form class="mx-auto" 
      action="{{ route('nominee.save') }}" 
      method="POST">
    @csrf

          <h3 class="text-center fw-bold mb-3">Add a nominee</h3>
          <p class="text-secondary text-center mb-4">
           You can add nominee(s) to your account. Adding nominees makes it easier to transfer ownership of your investments in case of any unfortunate eventuality.
        </p>

          @if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
 
@if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif


         <div id="nomineeWrapper">

    <!-- Nominee Block -->
    <div class="nominee-item position-relative">
        <h3 class="text-center fw-bold mb-3 mt-3">Nominee 1</h3>
        <button type="button" class="btn btn-sm btn-danger deleteNominee position-absolute top-0 end-0 m-2 d-none">
            ✕
        </button>

        <div class="row g-3 mb-2">
            <div class="col-md-12">
                <input type="text"  data-field="name" name="nominees[0][name]" class="form-control" placeholder="Nominee's Name">
            </div>

            <div class="col-md-6">
                <input type="text" data-field="pan" name="nominees[0][pan]" class="form-control" placeholder="Nominee's PAN">
            </div>

            <div class="col-md-6">
                <input placeholder="Nominee's date of birth" data-field="dob" type="text" name="nominees[0][dob]"   onfocus="setDobMax(this)" class="form-control" >
            </div>

            <div class="col-md-6">
                <input type="text" class="form-control" data-field="mobile"name="nominees[0][mobile]" placeholder="Nominee's mobile">
            </div>

            <div class="col-md-6">
                <input type="email" class="form-control" data-field="email"name="nominees[0][email]" placeholder="Nominee's e-mail">
            </div>

            <div class="col-md-6">
                <input type="text" class="form-control" data-field="relation"name="nominees[0][relation]" placeholder="The nominee is my">
            </div>

            <div class="col-md-6">
                <input type="number" class="form-control" data-field="share" name="nominees[0][share]" placeholder="Percentage of share(%)">
            </div>

            <div class="col-md-12">
                <div class="p-3 border rounded">
                    <label class="form-label">Address</label>
                    <div class="d-flex gap-4">
                        <label>As per my registered address</label>
                        <label><input type="radio"  data-field="same_address"name="nominees[0][same_address]" value="1" class="me-1"> Yes</label>
                        <label><input type="radio"  data-field="same_address"name="nominees[0][same_address]" value="0"class="me-1"> No</label>
                    </div>
                </div>
            </div>

        </div>
        <hr>
    </div>

</div>

<div class="text-center">
    <button id="addMore" type="button" class="btn btn-otp mb-2">
        Add Another Nominee +
    </button>
</div>

 <div class="col-md-12 d-flex justify-content-center gap-4 mt-4">
                    
    <button type="submit" class="btn btn-otp mb-2 btn-yellow">Continue</button>
 </div>


    </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script>
function setDobMax(input) {
    input.type = 'date';

    const today = new Date().toISOString().split('T')[0];
    input.max = today;
}
</script>

<script>
let nomineeCount = document.querySelectorAll(".nominee-item").length;

document.getElementById("addMore").addEventListener("click", function () {
    const wrapper = document.getElementById("nomineeWrapper");
    const firstNominee = document.querySelector(".nominee-item");
    const clone = firstNominee.cloneNode(true);

    nomineeCount++;

    clone.querySelectorAll("input").forEach(input => {
        input.value = "";
        input.checked = false;
    });

    clone.querySelector(".deleteNominee").classList.remove("d-none");

    wrapper.appendChild(clone);
    updateNomineeIndexes();
});

document.addEventListener("click", function (e) {
    if (e.target.classList.contains("deleteNominee")) {
        e.target.closest(".nominee-item").remove();
        updateNomineeIndexes();
    }
});

function updateNomineeIndexes() {
    document.querySelectorAll(".nominee-item").forEach((item, index) => {
        item.querySelector("h3").innerText = "Nominee " + (index + 1);

        item.querySelectorAll("input").forEach(input => {
            const field = input.dataset.field;
            if (field) {
                input.name = `nominees[${index}][${field}]`;
            }
        });

        const deleteBtn = item.querySelector(".deleteNominee");
        deleteBtn.classList.toggle("d-none", index === 0);
    });

    nomineeCount = document.querySelectorAll(".nominee-item").length;
}
</script>



</body>
</html>
