<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - User Profile</title>
@include('head')
</head>
<body>
@include('header-user') 
  <section class="hero-section">
    <div class="container">
        <!-- Progress Bar -->
    <div class="text-center mb-2 fw-semibold">20% Completed</div>
    <div class="progress-container">
        <div class="progress" style="height: 6px;">
            <div class="progress-bar" style="width: 20%;"></div>
        </div>
    </div>

      <div class="row g-4 align-items-center">
         <div class="col-lg-2"></div>
      <div class="col-lg-8">
          <div class="signup-card">

          @if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif


@if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif

            

            <form class="mx-auto" action="{{ route('zoho.contact.save') }}" method="POST" enctype="multipart/form-data" class=" mx-auto">
@csrf
              <div class="avatar-box" onclick="document.getElementById('avatarInput').click();">
                <img id="avatarPreview" src="{{ asset('assets/avtar.png') }}" alt="Avatar">
                <div class="cam-icon">📷</div>

                <!-- Hidden File Input -->
                <input type="file"  name="photo" id="avatarInput" accept="image/*" style="display:none" onchange="previewAvatar(event)">
            </div>

        <div class="row g-3 mb-2">
            <div class="col-md-6">
                <input type="text" class="form-control" name="first_name" placeholder="First Name" value="{{ $user->first_name }}"  readonly>
            </div>
            <div class="col-md-6">
                <input type="text" class="form-control"  name="last_name"placeholder="Last Name" value="{{ $user->last_name }}" >
            </div>
        </div>

        <div class="mb-3">
            <input type="text" class="form-control" name="phone" placeholder="Phone Number" value="{{ $user->mobile }}" readonly>
        </div>

        <div class="mb-3">
            <input type="email" class="form-control" name="email"placeholder="Email Id" value="{{ $user->email }}" readonly>
        </div>

        <!-- Gender -->
        <div class="mb-3 p-3 border rounded">
            <label class="form-label">Gender</label>
            <div class="d-flex gap-4">
                <label><input type="radio" name="gender" value="Male" class="me-1" > Male</label>
                <label><input type="radio" name="gender" value="Female"  class="me-1"> Female</label>
                <label><input type="radio" name="gender" value="Other" class="me-1"> Other</label>
            </div>
        </div>

        <!-- Buttons -->
        <div class="d-flex justify-content-center gap-4 mt-4">
            <button type="submit" name="action"  value="complete_profile" class="btn btn-otp mb-2 btn-red">Complete your Profile</button>
            <button type="submit" name="action" value="confirm" class="btn btn-otp mb-2 btn-yellow">Confirm</button>
        </div>

    </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function previewAvatar(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreview').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}
</script>
</body>
</html>
