<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Traits\ZohoCrmTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use App\Jobs\Uploadpaymentfile;
use App\Models\FundTransaction;
use Illuminate\Support\Facades\Validator;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\ZohoNotification;
use Illuminate\Support\Facades\Log;

class DashboardController extends Controller
{

    use ZohoCrmTrait;

    public function dashboard()
    {
        
         $user = auth()->user();
         $contactZohoId = auth()->user()->contactzohoid;

        $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
        $responseData = json_decode($response, true);
    
        if (empty($responseData['data'][0])) {
            abort(404, 'Zoho contact not found');
        }
        
        $contact = $responseData['data'][0];
        
        $credit_principal = $contact['Investment_Amount'];
        $Total_Withdrawl = $contact['Total_Withdrawal_Amount'];
        $Net_portfolio_value =$contact['Invested_Amount'];
        $Total_Return_Earned = $contact['Total_Returned_Earned'];
        $Return_Received = $contact['Total_Amount_Paid'];
        $Return_Receivable = (float)$Total_Return_Earned - (float)$Return_Received;



        // $module = 'chartofaccounts';
        // $recordId = '2431055000001405015';

        // $credit_principal = 0;
        // $debit_principal = 0;
        // $credit_return_payable = 0;
        // $debit_return_payable = 0;

        // $response = $this->getspecificaccountrecord($module, $recordId);
        // $jsonresponse = json_decode($response);
        // $transactions = $jsonresponse->chart_of_account->transactions;
        // foreach ($transactions as $trans) {
        //     $credit = $trans->credit;
        //     $debit = $trans->debit;
        //     if ($credit != null || $credit != "") {
        //         $credit_principal = $credit_principal + $credit;
        //     }
        //     if ($debit != null || $debit != "") {
        //         $debit_principal = $debit_principal + $debit;
        //     }
        //     $balance_principal = round($credit_principal, 2) - round($debit_principal, 2);

        // }
        

        // $recordIdd = '2431055000001405024';
        // $response2 = $this->getspecificaccountrecord($module, $recordIdd);
        // $jsonresponse2 = json_decode($response2);
        // $transactions2 = $jsonresponse2->chart_of_account->transactions;
        // foreach ($transactions2 as $trans2) {
        //     $credit2 = $trans2->credit;
        //     $debit2 = $trans2->debit;
        //     if ($credit2 != null || $credit2 != "") {
        //         $credit_return_payable = $credit_return_payable + $credit2;
        //     }
        //     if ($debit2 != null || $debit2 != "") {
        //         $debit_return_payable = $debit_return_payable + $debit2;
        //     }
        //     $balance_return_payable = round($credit_return_payable, 2) - round($debit_return_payable, 2);
        // }

        // $Total_Withdrawl = round($debit_return_payable, 2) + round($debit_principal, 2);
        // $Net_portfolio_value = $balance_return_payable + $balance_principal;
        // $Total_Return_Earned = $credit_return_payable;
        // $Return_Received = round($debit_return_payable );
        // $Return_Receivable = $balance_return_payable;


        return view('dashboard', compact(
            'credit_principal',
            'Total_Withdrawl',
            'Net_portfolio_value',
            'Total_Return_Earned',
            'Return_Received',
            'Return_Receivable'
           
        ));
    }
    
    
public function investmentform(){
     $user = auth()->user();
         $contactZohoId = auth()->user()->contactzohoid;

        $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
        $responseData = json_decode($response, true);
    
        if (empty($responseData['data'][0])) {
            abort(404, 'Zoho contact not found');
        }
        
        $contact = $responseData['data'][0];
        
         if (($contact['Verification_Step'] ?? 0) != 7) {
        return redirect()->route('dashboard') // or any page you want
            ->with('error', 'Please complete your KYC before making an investment.');
    }
        $First_Name = $contact['First_Name'];
        $Last_Name = $contact['Last_Name'] ;
        $name = $First_Name .' '. $Last_Name;
        $address = $contact['Aadhaar_Address'];
        $phone = $contact['Phone'];
        $email = $contact['Email'];
        $pan = $contact['PAN'];
        $fathername = $contact['Father_s_Name'];
        $accountnumber = $contact['Account_Number'];
        
    
    return view('investmentform' , compact('name' ,'address','phone','email','pan','fathername','accountnumber'));
    
}





public function investmentattachment(Request $request)
{
    $validated = $request->validate([
        'security_type' => 'required|string',
        'govt_approval' => 'required|string',
    ]);

    $user = Auth::user();


    $user->update([
        'security_type' => $validated['security_type'],
    ]);

    $contactZohoId = $user->contactzohoid;
    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);

    $contact = $responseData['data'][0];

 
    $name    = $contact 
    ? trim(($contact['First_Name'] ?? '') . ' ' . ($contact['Last_Name'] ?? ''))
    : 'NA';
    $father  = $contact['Father_Name'] ?? 'NA';
    $address = $contact['Aadhaar_Address'] ?? 'NA';
    $phone   = $contact['Phone'] ?? 'NA';
    $email   = $contact['Email'] ?? 'NA';
    $pan     = $contact['PAN'] ?? 'NA';
    $bank    = $contact['Bank_Details'] ?? 'NA';


    $pdf = Pdf::loadView('pdf.pas4', [
        'name'           => $name,
        'father'         => $father,
        'address'        => $address,
        'phone'          => $phone,
        'email'          => $email,
        'pan'            => $pan,
        'bank'           => $bank,
        'security_type'  => $validated['security_type'],
        'govt_approval'  => $validated['govt_approval'],
    ])->setPaper('A4');

    $fileName = 'PAS4_' . $contactZohoId . '_' . now()->format('Ymd_His') . '.pdf';
    $filePath = 'pas4/' . $fileName;

    Storage::put($filePath, $pdf->output());
    

    return redirect()->route('home_dashboard');
}

public function homedashboard()
{
    $user = auth()->user();

    $security_type = $user->security_type;
    $contactZohoId = $user->contactzohoid;

    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);

    $contact = $responseData['data'][0] ?? null;
    $frequency = $contact['Preference_for_Running_Account_Settlement'] ?? null;
    
 

    if (!$frequency && !$security_type) {
        return view('dashboard', [
            'products' => collect(),
            'error' => 'Please complete your profile to view products.'
        ]);
    }
    
    

    $criteria = "(Frequency:equals:$frequency) 
                and (Security_Type:equals:$security_type) 
                and (Product_Active:equals:true)";

    $response = $this->searchRecordsProducts('Products', $criteria);
    $responseData = json_decode($response, true);

 
     $productsCollection = collect($responseData['data'] ?? [])->map(function ($item) {
        return [
            'product_id'        => $item['id'] ?? '',
            'product_name'      => $item['Product_Name'] ?? '',
            'rate_of_interest'  => $item['Rate_of_Interest'] ?? 0,
            'minimum_investment'=> $item['Per_Lot_Amount'] ?? 0,
            'tenure_in_month'   => $item['Tenure_in_Months'] ?? '',
            'security_type'     => $item['Security_Type'] ?? '',
            'Frequency'         => $item['Frequency'] ?? '',
        ];
    });
    
 $perPage =6;
 $productsPage = request()->get('page', 1);

    $products = new LengthAwarePaginator(
        $productsCollection->forPage($productsPage, $perPage),
        $productsCollection->count(),
        $perPage,
        $productsPage,
        [
            'path' => request()->url(),
           
        ]
    );
    
    
 

    return view('home-dashboard', compact('products'));
}



public function raiseRequest(Request $request)
{
    $contactid = auth()->user()->contactzohoid;

    $validated = $request->validate([
        'product_id'    => 'required|string',
        'security_type' => 'required|string',
        'frequency'     => 'required|string',
        'unit'          => 'required|integer|min:1',
        'total_amount'  => 'required|numeric|min:1',
        'product_name'  => 'required'
    ]);

    $dealName = $validated['product_name'] . ' - ' . now()->format('d M Y');

    $payload = [
        'data' => [[
            'Deal_Name'           => $dealName,
            'Pipeline'            => 'Investment',
            'Type'                => 'Investment',
            'Stage'               => 'Draft',
            'Investor'            => $contactid,
            'Security_Type'       => $validated['security_type'],
            'Unit'                => $validated['unit'],
            'Investment_Amount'   => $validated['total_amount'],
            'Invested_Amount'     => $validated['total_amount'],
            'Products'            => $validated['product_id'],
            'Interest_Frequency'  => $validated['frequency'],
            'Investment_Status'   => 'Pending'
        ]]
    ];

    $response = $this->createZohoCrmRecord('Deals', $payload);
    $responseData = json_decode($response, true);

    if (
        empty($responseData['data'][0]) ||
        $responseData['data'][0]['status'] !== 'success'
    ) {
        return response()->json([
            'status'  => 'error',
            'message' => $responseData['data'][0]['message'] ?? 'Zoho Deal creation failed'
        ], 422);
    }
    

    $dealId = $responseData['data'][0]['details']['id'];


    $latestPdf = $this->getLatestPas4Pdf($contactid);

    if (! $latestPdf) {
        return response()->json([
            'status'  => 'error',
            'message' => 'PAS-4 PDF not found for this investor'
        ], 422);
    }

    $absolutePath = storage_path('app/' . $latestPdf);
    


    $attachmentResponse = $this->uploadZohoCrmRecordAttachment(
        'Deals',
        $dealId,
        Storage::path($latestPdf)
    );
    
    if (
        empty($attachmentResponse['data'][0]) ||
        $attachmentResponse['data'][0]['status'] !== 'success'
    ) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Deal created but PAS-4 attachment upload failed'
        ], 422);
    }

    // Ã¢Å“â€¦ Both deal + attachment successful
    return response()->json([
        'status'  => 'success',
        'redirect' => route('investment.request'),
    ]);
}



private function getLatestPas4Pdf($contactZohoId)
{
    $files = Storage::files('pas4');

   
    $matchedFiles = collect($files)->filter(function ($file) use ($contactZohoId) {
        return str_starts_with(basename($file), 'PAS4_' . $contactZohoId . '_');
    });

    if ($matchedFiles->isEmpty()) {
        return null;
    }

 
    return $matchedFiles
        ->sortByDesc(fn ($file) => Storage::lastModified($file))
        ->first();
}

private function getLatestWithdrawlPdf($contactZohoId)
{
    $files = Storage::files('Withdrawl');

   
    $matchedFiles = collect($files)->filter(function ($file) use ($contactZohoId) {
        return str_starts_with(basename($file), 'Withdrawl' . $contactZohoId . '_');
    });

    if ($matchedFiles->isEmpty()) {
        return null;
    }

 
    return $matchedFiles
        ->sortByDesc(fn ($file) => Storage::lastModified($file))
        ->first();
}

public function requestdashboard()
{
    $contactid = auth()->user()->contactzohoid;

    $response = $this->getZohoCrmRelatedRecords('Contacts', $contactid, 'Deals1');
    $responseData = json_decode($response, true);

    $relatedDeals = collect($responseData['data'] ?? []);

    // 2. Fetch full deal details one by one
    $deals = collect();

    foreach ($relatedDeals as $item) {
        if (!empty($item['id'])) {

            $dealResponse = $this->getZohoCrmSpecificRecords('Deals', $item['id']);
            $dealData = json_decode($dealResponse, true);
            

            if (!empty($dealData['data'][0])) {
                $deals->push($dealData['data'][0]);
            }
        }
    }
    
    // echo "<pre>";
    // print_r($deals);die;
    
     $deals = $deals->sortByDesc(function ($deal) {
        return isset($deal['Created_Time'])
            ? Carbon::parse($deal['Created_Time'])
            : Carbon::minValue();
    })->values();
    
    
     // PAGINATE INVESTMENT DEALS
    $perPage = 10;
    $currentPage = request()->get('page', 1);

    $pagedDeals = new LengthAwarePaginator(
        $deals->forPage($currentPage, $perPage),
        $deals->count(),
        $perPage,
        $currentPage,
        ['path' => request()->url()]
    );
    
    
    //withdrawl 
    
    $responsewithdraw = $this->getZohoCrmRelatedRecords('Contacts', $contactid, 'Deals');
    $responseDatawithdraw = json_decode($responsewithdraw, true);

    $relatedDealswithdraw = collect($responseDatawithdraw['data'] ?? []);

    // 2. Fetch full deal details one by one
    $dealswithdraw = collect();

    // foreach ($relatedDealswithdraw as $item) {
    //     if (!empty($item['id'])) {

    //         $dealResponsewithdraw = $this->getZohoCrmSpecificRecords('Deals', $item['id']);
    //         $dealDatawithdraw = json_decode($dealResponsewithdraw, true);
            

    //         if (!empty($dealDatawithdraw['data'][0])) {
    //             $dealswithdraw->push($dealDatawithdraw['data'][0]);
    //         }
    //     }
    // }
    
foreach ($relatedDealswithdraw as $item) {

    $dealId = $item['id'] ?? null;
    if (!$dealId) continue;

    $response = $this->getZohoCrmSpecificRecords('Deals', $dealId);
    $data = json_decode($response, true);
    $withdrawDeal = $data['data'][0] ?? null;
    
    

    if (!$withdrawDeal || strtolower($withdrawDeal['Type'] ?? '') !== 'withdrawal') {
        continue;
    }

    $investmentDealId = $withdrawDeal['Investment_Deal']['id'] ?? null;
    if (!$investmentDealId) continue;

    $investmentResponse = $this->getZohoCrmSpecificRecords('Deals', $investmentDealId);
    $investmentData = json_decode($investmentResponse, true);
    $investmentDeal = $investmentData['data'][0] ?? null;
    
    // echo "<pre>";
    // print_r($investmentDeal['Products']['id']);die;

    if ($investmentDeal) {

        $dealswithdraw->push([
             'Product_Id' => $investmentDeal['Products']['id'] ?? null, 
            'Product_Name' =>$investmentDeal['Products']['name'] ?? 'N/A',
          
            'Withdrawal_Amount' => $withdrawDeal['Withdrawal_Amount'] ?? 0,
               'Withdrawal_Unit' => $withdrawDeal['Withdrawal_Unit'] ?? 0,
            'Security_Type' => $investmentDeal['Security_Type'] ?? null,
            'Created_Time' => $withdrawDeal['Created_Time'] ?? null,
        ]);
    }
}


// Sort latest first
$dealswithdraw = $dealswithdraw->sortByDesc(function ($deal) {
    return isset($deal['Created_Time'])
        ? Carbon::parse($deal['Created_Time'])
        : Carbon::minValue();
})->values();



 // PAGINATE WITHDRAWALS (different page parameter!)
    $withdrawPage = request()->get('withdraw_page', 1);
    
   

    $pagedWithdrawals = new LengthAwarePaginator(
        $dealswithdraw->forPage($withdrawPage, $perPage),
        $dealswithdraw->count(),
        $perPage,
        $withdrawPage,
        [
            'path' => request()->url(),
            'pageName' => 'withdraw_page'
        ]
    );
    
 

    //return view('investmentrequeststatus', compact('deals' ,'dealswithdraw'));
     return view('investmentrequeststatus', [
        'deals' => $pagedDeals,
        'dealswithdraw' => $pagedWithdrawals
    ]);
}




public function paymentApproved(Request $request)
{
   
     $validator = \Validator::make($request->all(), [
        'product_name' => 'required|string',
        'amount'       => 'required|numeric',
        'unit'         => 'required|numeric',
        'email'        => 'required|email',
        'dealid'       => 'required|string',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Invalid webhook payload',
            'errors'  => $validator->errors()
        ], 200); // 👈 still 200 (important)
    }
    $productName = $request->product_name;
    $amount      = $request->amount;
    $unit        = $request->unit;
    $email       = $request->email;
    $dealid      = $request->dealid;

    $uploadUrl = URL::temporarySignedRoute(
        'receipt.upload.form',
        now()->addHours(24),
        [
            'product_name' => $productName, // ðŸ”¥ MUST MATCH
            'amount'       => $amount,
            'unit'         => $unit,
            'dealid'       => $dealid
        ]
    );
    
    $payload = [
    'data' => [
        [
            'Payment_Webtab' => $uploadUrl, // 👈 CRM field API name
        ]
    ]
];
    
     $updateResponse = $this->updateZohoCrmRecord(
            'Deals',
            $dealid,
            $payload
        );
        
        log::info($updateResponse);
        
         $updateDecoded = json_decode($updateResponse?? '', true);

        if (
            !isset($updateDecoded['data'][0]['code']) ||
            $updateDecoded['data'][0]['code'] !== 'SUCCESS'
        ) {
            return response()->json([
        'status' => 'failed'
    ], 200);
    
    
        }
        
        return response()->json([
    'status' => 'success'
], 200);

}     
        

     


public function showUploadForm(Request $request)
{
    return view('paymentsummary', [
        'productName' => $request->product_name,
        'amount'      => $request->amount,
        'unit'        => $request->unit,
        'dealid'      => $request->dealid,
    ]);
}

public function store(Request $request)
{
    try {
        $request->validate([
            'receipt' => 'required|file|mimes:jpg,jpeg,png,pdf|max:5120',
            'dealid'  => 'required|string',
        ]);

   

        $path = $request->file('receipt')->store('payment-receipts');

        if (!$path) {
            return back()->with('error', 'File upload failed.');
        }

         $fullPath = Storage::disk('local')->path($path);

        if (!file_exists($fullPath)) {
            return back()->with('error', 'Uploaded file not found.');
        }

     

        $photoResponse = $this->updateZohoCrmRecordPhoto(
            'Deals',
            $request->dealid,
            $fullPath
        );

        if (!isset($photoResponse['response'])) {
            return back()->with('error', 'Zoho did not respond.');
        }

        $photoDecoded = json_decode($photoResponse['response'], true);

        if (
            !isset($photoDecoded['data'][0]['code']) ||
            $photoDecoded['data'][0]['code'] !== 'SUCCESS'
        ) {
            return back()->with(
                'error',
                $photoDecoded['data'][0]['message'] ?? 'Zoho file upload failed'
            );
        }

        /* ------------------ Get File ID ------------------ */

        $fileId = $photoDecoded['data'][0]['details']['id'] ?? null;

        if (!$fileId) {
            return back()->with('error', 'File uploaded but File ID not returned.');
        }

    

        $payload = [
            'data' => [
                [
                    'id' => $request->dealid,
                    'Payment_SS' => [
                        [
                            'File_Id__s' => $fileId
                        ]
                    ]
                ]
            ]
        ];

        $updateResponse = $this->updateZohoCrmRecord(
            'Deals',
            $request->dealid,
            $payload
        );
    

        $updateDecoded = json_decode($updateResponse?? '', true);
        
      

        if (
            !isset($updateDecoded['data'][0]['code']) ||
            $updateDecoded['data'][0]['code'] !== 'SUCCESS'
        ) {
            return back()->with(
                'error',
                $updateDecoded['data'][0]['message'] ?? 'Zoho record update failed'
            );
        }

       return redirect()->route('payment.thankyou');
    } catch (\Throwable $e) {
        \Log::error('Payment Upload Error', [
            'message' => $e->getMessage()
        ]);

        return back()->with('error', 'Something went wrong. Please try again.');
    }
}

public function paymentthankyou(){
    return view('paymentthankyou');
}


public function fetchtransactiondata(Request $request)
{
    $contactZohoId = auth()->user()->contactzohoid;

    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);
    $contact = $responseData['data'][0] ?? null;

    $query = FundTransaction::where('contactzohoid', $contactZohoId);

    $range = $request->range;

    switch ($range) {

        case 'today':
            $fromDate = Carbon::today();
            $toDate   = Carbon::today();
            break;

        case 'yesterday':
            $fromDate = Carbon::yesterday();
            $toDate   = Carbon::yesterday();
            break;

        case 'this_week':
            $fromDate = Carbon::now()->startOfWeek();
            $toDate   = Carbon::now()->endOfWeek();
            break;

        case 'previous_week':
            $fromDate = Carbon::now()->subWeek()->startOfWeek();
            $toDate   = Carbon::now()->subWeek()->endOfWeek();
            break;

        case 'this_month':
            $fromDate = Carbon::now()->startOfMonth();
            $toDate   = Carbon::now()->endOfMonth();
            break;

        case 'previous_month':
            $fromDate = Carbon::now()->subMonth()->startOfMonth();
            $toDate   = Carbon::now()->subMonth()->endOfMonth();
            break;

        case 'this_quarter':
            $fromDate = Carbon::now()->startOfQuarter();
            $toDate   = Carbon::now()->endOfQuarter();
            break;

        case 'previous_quarter':
            $fromDate = Carbon::now()->subQuarter()->startOfQuarter();
            $toDate   = Carbon::now()->subQuarter()->endOfQuarter();
            break;

        case 'this_year':
            $fromDate = Carbon::now()->startOfYear();
            $toDate   = Carbon::now()->endOfYear();
            break;

        case 'previous_year':
            $fromDate = Carbon::now()->subYear()->startOfYear();
            $toDate   = Carbon::now()->subYear()->endOfYear();
            break;


        default:
            $fromDate = Carbon::now()->subMonth();
            $toDate   = Carbon::now();
            break;
    }
    


    $query->whereDate('transaction_date', '>=', $fromDate)
          ->whereDate('transaction_date', '<=', $toDate);

    $transactions = $query
        ->orderBy('transaction_date', 'desc')
        ->paginate(10)
        ->withQueryString();

    return view('transactiondetails', compact(
        'contact',
        'transactions',
        'fromDate',
        'toDate'
    ));
}

// public function fetchtransactiondata(Request $request)
// {
//     $contactZohoId = auth()->user()->contactzohoid;

//     $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
//     $responseData = json_decode($response, true);
//     $contact = $responseData['data'][0] ?? null;

//     $query = FundTransaction::where('contactzohoid', $contactZohoId);

//     if ($request->filled('from_date') && $request->filled('to_date')) {
//         $fromDate = $request->from_date;
//         $toDate   = $request->to_date;
//     } else {
//         $fromDate = now()->subMonth()->toDateString();
//         $toDate   = now()->toDateString();
//     }

//     $query->whereDate('transaction_date', '>=', $fromDate)
//           ->whereDate('transaction_date', '<=', $toDate);

//     // $transactions = $query->orderBy('transaction_date', 'desc')->get();
    
//     $transactions = $query
//     ->orderBy('transaction_date', 'desc')
//     ->paginate(10)
//     ->withQueryString(); // preserves from_date & to_date

//     return view('transactiondetails', compact(
//         'contact',
//         'transactions',
//         'fromDate',
//         'toDate'
//     ));
// }

public function transcationdata(Request $request)
{
    $validator = Validator::make($request->all(), [
        'data' => 'required|array',
        'data.*.contactzohoid' => 'required',
        'data.*.transaction_date' => 'required|date',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'status' => false,
            'message' => $validator->errors()
        ], 422);
    }

    foreach ($request->data as $txn) {

        FundTransaction::updateOrCreate(
            [
                'contactzohoid'   => $txn['contactzohoid'],
                'transaction_date'=> $txn['transaction_date'] ?? null,
                'settlement_date' => $txn['settlement_date'] ?? null,
                'security_type'   => $txn['security_type'] ?? null,
                'narration'       => $txn['narration'] ?? null,
                'cheque_no'       => $txn['cheque_no'] ?? null,
                'transaction_type'=> $txn['transaction_type'] ?? null,
                'debit'           => $txn['debit'] ?? 0,
                'credit'          => $txn['credit'] ?? 0,
                'balance'         => $txn['balance'] ?? 0,
                 'voucher_no' => $txn['voucher_no'] ?? null
            ]
        );
    }

    return response()->json([
        'status' => true,
        'message' => 'Transactions saved successfully'
    ]);
}

public function withdrawlform(){
     $user = auth()->user();
         $contactZohoId = auth()->user()->contactzohoid;

        $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
        $responseData = json_decode($response, true);
    
        if (empty($responseData['data'][0])) {
            abort(404, 'Zoho contact not found');
        }
        
        $contact = $responseData['data'][0];
        
    //      if (($contact['Verification_Step'] ?? 0) != 6) {
    //     return redirect()->route('dashboard') // or any page you want
    //         ->with('error', 'Please complete your KYC before making an investment.');
    // }
        $First_Name = $contact['First_Name'];
        $Last_Name = $contact['Last_Name'] ;
        $name = $First_Name .' '. $Last_Name;
        $address = $contact['Aadhaar_Address'];
        $phone = $contact['Phone'];
        $email = $contact['Email'];
        $pan = $contact['PAN'];
        $fathername = $contact['Father_s_Name'];
        
    
    return view('withdrawlform' , compact('name' ,'address','phone','email','pan','fathername'));
    
}

public function withdrawlattachment(Request $request)
{
    $validated = $request->validate([
        'security_type' => 'required|string',
    ]);

    $user = Auth::user();


    $user->update([
        'withdrawl_security_type' => $validated['security_type'],
    ]);

    $contactZohoId = $user->contactzohoid;
    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);

    $contact = $responseData['data'][0];

 
    $name    = $contact 
    ? trim(($contact['First_Name'] ?? '') . ' ' . ($contact['Last_Name'] ?? ''))
    : 'NA';
    $father  = $contact['Father_Name'] ?? 'NA';
    $address = $contact['Aadhaar_Address'] ?? 'NA';
    $phone   = $contact['Phone'] ?? 'NA';
    $email   = $contact['Email'] ?? 'NA';
    $pan     = $contact['PAN'] ?? 'NA';
    $bank    = $contact['Bank_Details'] ?? 'NA';

    $pdf = Pdf::loadView('pdf.withdrawlform', [
        'name'           => $name,
        'father'         => $father,
        'address'        => $address,
        'phone'          => $phone,
        'email'          => $email,
        'pan'            => $pan,
        'bank'           => $bank,
        'security_type'  => $validated['security_type'],
       
    ])->setPaper('A4');

    $fileName = 'Withdrawl' . $contactZohoId . '_' . now()->format('Ymd_His') . '.pdf';
    $filePath = 'Withdrawl/' . $fileName;

    Storage::put($filePath, $pdf->output());
    

    return redirect()->route('investmentwithdrawlproducts');
}

// public function investmentwithdrawlproducts()
// {
//     $user = auth()->user();
//     $contactid = $user->contactzohoid;


//     $userSecurityType = $user->security_type;

 
//     $response = $this->getZohoCrmRelatedRecords('Contacts', $contactid, 'Deals1');
//     $responseData = json_decode($response, true);

//     $relatedDeals = collect($responseData['data'] ?? []);
//     $deals = collect();

//     foreach ($relatedDeals as $item) {
//         if (!empty($item['id'])) {

//             $dealResponse = $this->getZohoCrmSpecificRecords('Deals', $item['id']);
//             $dealData = json_decode($dealResponse, true);

//             if (!empty($dealData['data'][0])) {
//                 $deals->push($dealData['data'][0]);
//             }
//         }
//     }

//     $deals = $deals->sortByDesc(function ($deal) {
//         return isset($deal['Created_Time'])
//             ? \Carbon\Carbon::parse($deal['Created_Time'])
//             : \Carbon\Carbon::minValue();
//     })->values();



//     $filteredDeals = $deals->filter(function ($deal) use ($userSecurityType) {

//         $stage = strtolower($deal['Investment_Status'] ?? '');
//         $securityType = $deal['Security_Type'] ?? null;

//         return $stage === 'active'
//             && $securityType === $userSecurityType;
//     });

//     return view('investmentproductsforwithdrawl', [
//         'deals' => $filteredDeals
//     ]);
// }

public function investmentwithdrawlproducts()
{
    $user = auth()->user();
    $contactid = $user->contactzohoid;
    $userSecurityType = $user->security_type;

    $response = $this->getZohoCrmRelatedRecords('Contacts', $contactid, 'Deals1');
    $responseData = json_decode($response, true);

    $relatedDeals = collect($responseData['data'] ?? []);
    $deals = collect();

    foreach ($relatedDeals as $item) {
        if (!empty($item['id'])) {
            $dealResponse = $this->getZohoCrmSpecificRecords('Deals', $item['id']);
            $dealData = json_decode($dealResponse, true);

            if (!empty($dealData['data'][0])) {
                $deals->push($dealData['data'][0]);
            }
        }
    }

    // Sort by Created Time (Latest First)
    $deals = $deals->sortByDesc(function ($deal) {
        return isset($deal['Created_Time'])
            ? \Carbon\Carbon::parse($deal['Created_Time'])
            : \Carbon\Carbon::minValue();
    })->values();

    // Filter Active + Security Type
    $filteredDeals = $deals->filter(function ($deal) use ($userSecurityType) {
        $stage = strtolower($deal['Investment_Status'] ?? '');
        $securityType = $deal['Security_Type'] ?? null;

        return $stage === 'active'
            && $securityType === $userSecurityType;
    })->values();

   
    
$page = request()->get('page', 1);
$perPage = 10;

$paginatedDeals = new LengthAwarePaginator(
    $filteredDeals->forPage($page, $perPage),
    $filteredDeals->count(),
    $perPage,
    $page,
    [
        'path' => request()->url(),
        'query' => request()->query()
    ]
);

    return view('investmentproductsforwithdrawl', [
        'deals' => $paginatedDeals
    ]);
}

public function withdrawlraiseRequest(Request $request)
{
    $contactid = auth()->user()->contactzohoid;

    $validated = $request->validate([
         'Deal_ID' => 'required',
    'Withdrawal_Amount' => 'required|numeric|min:1',
    'Units' => 'required|integer|min:1'
    ]);


   $dealId = $validated['Deal_ID'];
//$dealName = $validated['Deal_Name'];
$amount = $validated['Withdrawal_Amount'];
$units = $validated['Units'];
    
    $currentDate = Carbon::now()->format('Y-m-d');

    $payload = [
        'data' => [[
            'Withdrawal_Amount' => $amount,
            'Withdrawal_Date' =>$currentDate ,
            'Deal_Name' => "Withdrawl_Request_".$contactid,
            'Pipeline' => "Withdrawal" ,
            'Stage' => "Draft" ,
            'Type'  => "Withdrawal",
            'Contact_Name' => $contactid,
            'Investment_Deal' => $dealId,
            'Withdrawal_Unit' => $units
            
        ]]
    ];

    $response = $this->createZohoCrmRecord('Deals', $payload);
    $responseData = json_decode($response, true);

    if (
        empty($responseData['data'][0]) ||
        $responseData['data'][0]['status'] !== 'success'
    ) {
        return response()->json([
            'status'  => 'error',
            'message' => $responseData['data'][0]['message'] ?? 'Zoho Deal creation failed'
        ], 422);
    }
    

    $dealId = $responseData['data'][0]['details']['id'];


    $latestPdf = $this->getLatestWithdrawlPdf($contactid);

    if (! $latestPdf) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Withdrawl PDF not found for this investor'
        ], 422);
    }

    $absolutePath = storage_path('app/' . $latestPdf);
    
    $attachmentResponse = $this->uploadZohoCrmRecordAttachment(
        'Deals',
        $dealId,
        Storage::path($latestPdf)
    );
    
    if (
        empty($attachmentResponse['data'][0]) ||
        $attachmentResponse['data'][0]['status'] !== 'success'
    ) {
        return response()->json([
            'status'  => 'error',
            'message' => 'Deal created but PAS-4 attachment upload failed'
        ], 422);
    }

    return response()->json([
        'status'  => 'success',
        'redirect' => route('investment.request'),
    ]);
}

public function downloadTransactionStatement(Request $request)
{
    $user = auth()->user();
    $contactZohoId = $user->contactzohoid;

    // Fetch contact details
    $response = $this->getZohoCrmSpecificRecords('Contacts', $contactZohoId);
    $responseData = json_decode($response, true);
    $contact = $responseData['data'][0] ?? null;

    $query = FundTransaction::where('contactzohoid', $contactZohoId);

    $range = $request->range;

    switch ($range) {

        case 'today':
            $fromDate = Carbon::today();
            $toDate   = Carbon::today();
            break;

        case 'yesterday':
            $fromDate = Carbon::yesterday();
            $toDate   = Carbon::yesterday();
            break;

        case 'this_week':
            $fromDate = Carbon::now()->startOfWeek();
            $toDate   = Carbon::now()->endOfWeek();
            break;

        case 'previous_week':
            $fromDate = Carbon::now()->subWeek()->startOfWeek();
            $toDate   = Carbon::now()->subWeek()->endOfWeek();
            break;

        case 'this_month':
            $fromDate = Carbon::now()->startOfMonth();
            $toDate   = Carbon::now()->endOfMonth();
            break;

        case 'previous_month':
            $fromDate = Carbon::now()->subMonth()->startOfMonth();
            $toDate   = Carbon::now()->subMonth()->endOfMonth();
            break;

        case 'this_quarter':
            $fromDate = Carbon::now()->startOfQuarter();
            $toDate   = Carbon::now()->endOfQuarter();
            break;

        case 'previous_quarter':
            $fromDate = Carbon::now()->subQuarter()->startOfQuarter();
            $toDate   = Carbon::now()->subQuarter()->endOfQuarter();
            break;

        case 'this_year':
            $fromDate = Carbon::now()->startOfYear();
            $toDate   = Carbon::now()->endOfYear();
            break;

        case 'previous_year':
            $fromDate = Carbon::now()->subYear()->startOfYear();
            $toDate   = Carbon::now()->subYear()->endOfYear();
            break;

        case 'custom':
            if ($request->filled('from_date') && $request->filled('to_date')) {
                $fromDate = Carbon::parse($request->from_date);
                $toDate   = Carbon::parse($request->to_date);
            } else {
                $fromDate = Carbon::now()->subMonth();
                $toDate   = Carbon::now();
            }
            break;

        default:
            $fromDate = Carbon::now()->subMonth();
            $toDate   = Carbon::now();
            break;
    }

    $query->whereDate('transaction_date', '>=', $fromDate)
          ->whereDate('transaction_date', '<=', $toDate);

    // ✅ NO PAGINATION FOR PDF
    $transactions = $query
        ->orderBy('transaction_date', 'desc')
        ->get();

    $pdf = Pdf::loadView(
        'pdf.transaction_statement',
        compact('contact', 'transactions', 'fromDate', 'toDate')
    );

    return $pdf->download('statement.pdf');
}


public function fetchProductPhoto($productId)
{
    $files = Storage::disk('public')->files('product_images');

    // Find file that starts with productId
    $filePath = collect($files)->first(function ($file) use ($productId) {
        return str_starts_with(basename($file), $productId . '.');
    });

    if (!$filePath) {
        abort(404);
    }

    $fullPath = storage_path('app/public/' . $filePath);

    return response()->file($fullPath);
}

 public function storeProductImage(Request $request)
    {
       Log::info('Zoho Payload:', $request->all());
       Log::info('Files:', $request->allFiles());
        $productId = $request->input('productid');

        if (!$productId || !$request->hasFile('image')) {
            return response()->json(['message' => 'Missing product ID or image'], 400);
        }

        $file = $request->file('image');
        $extension = $file->getClientOriginalExtension();

        $fileName = "product_images/{$productId}.{$extension}";

        Storage::disk('public')->put(
            $fileName,
            file_get_contents($file)
        );

        return response()->json(['message' => 'Image stored successfully']);
    }


public function notification(Request $request)
{
    if (!$request->contactid) {
        return response()->json(['error' => 'Contact ID missing'], 400);
    }

    ZohoNotification::create([
        'contact_id' => $request->contactid,
        'title'      => $request->title,
        'message'    => $request->message,
    ]);

    return response()->json(['success' => true]);
}

public function getNotifications()
{
    $contactId = auth()->user()->contactzohoid;

    $notifications = ZohoNotification::where('contact_id', $contactId)
        ->get()
        ->map(function ($notification) {
            return [
                'id'       => $notification->id,
                'title'    => $notification->title,
                'message'  => $notification->message,
                'is_read'  => $notification->is_read,
                'time_ago' => Carbon::parse($notification->created_at)->diffForHumans(),
            ];
        });

    $count = ZohoNotification::where('contact_id', $contactId)
        ->where('is_read', false)
        ->count();

    return response()->json([
        'count' => $count,
        'notifications' => $notifications
    ]);
}

public function markAsRead()
{
    $contactId = auth()->user()->contactzohoid;

    ZohoNotification::where('contact_id', $contactId)
        ->where('is_read', false)
        ->update(['is_read' => true]);

    return response()->json(['success' => true]);
}

public function destroy($contactid){
    $user = User::where('contactid', $contactid)->first();

        if (!$user) {
            return response()->json([
                'message' => 'User not found'
            ], 404);
        }

        $user->delete();

        return response()->json([
            'message' => 'User deleted successfully'
        ]);
    }



}
