<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Mail\EmailOtpMail;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Services\UserService;
use App\Traits\ZohoCrmTrait;

class LoginController extends Controller
{
     protected $userService;
      use ZohoCrmTrait;

    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
    }


   public function login()
{
    // If already logged in, NEVER show login page
    if (auth()->check()) {

        $user = auth()->user();

        // Get verification step (prefer DB if available)
        $step = null;

        try {
            $data = $this->searchRecordsbyrecordid('Contacts', $user->contactzohoid);
            $datajson = json_decode($data, true);
            $step = $datajson['data'][0]['Verification_Step'] ?? null;
        } catch (\Exception $e) {
            Log::error('Zoho fetch failed', ['error' => $e->getMessage()]);
        }

        switch ($step) {
            case '1': return redirect()->route('pancardpage');
            case '2': return redirect()->route('aadharpage');
            case '3': return redirect()->route('aadharkycpage2');
            case '4': return redirect()->route('bankdetailpage');
            case '5': return redirect()->route('webcampage');
            case '6': return redirect()->route('nomineepage');
            case '7': return redirect()->route('dashboard');
            default:  return redirect()->route('dashboard');
        }
    }

    return response()
        ->view('login');
       
}


    public function loginpasscode(Request $request)
   {
    $request->validate([
        'email_or_phone' => 'required'
    ]);
    $input = $request->email_or_phone;
    $user = User::where('email', $input)
                ->orWhere('mobile', $input)
                ->where('status' , 1)
                ->first();
    if (!$user) {
        return back()->withErrors([
            'email_or_phone' => 'Email or Phone number not found'
        ])->withInput();
    }
    session(['login_user_id' => $user->id]);
    return view('forgot_passcode', compact('user'));
  }

  public function passcodepage()
{
    // If already logged in, don't allow OTP page
    if (auth()->check()) {
        return redirect()->route('dashboard');
    }

    // If session missing, force login
    if (!session()->has('login_user_id')) {
        return redirect()->route('login');
    }

    return view('forgot_passcode');
}

//   public function submitpasscode(Request $request)
//   {

  
//      $request->validate([
//         'otp' => 'required|size:4',
       
//     ]);

   
//     $enteredPasscode = implode('', $request->otp);
//     $userId = session('login_user_id');

//      if (!$userId) {
//         return redirect()->route('login')
//             ->with('error', 'Session expired. Please login again.');
//     }
     
//     $user = User::find($userId);
    
    

//     if (!$user || !Hash::check($enteredPasscode, $user->passcode)) {
//         return redirect()
//             ->route('passcodepageenter')
//             ->withErrors(['passcode' => 'Incorrect passcode']);
//     }
    

//     auth()->login($user);
//     session()->regenerate();
//     session()->forget('login_user_id');
    
//     $data = $this->searchRecordsbyrecordid('Contacts', $user->contactzohoid);
    
//     $datajson = json_decode($data, true); // ðŸ‘ˆ decode as array
    
//     $zohoContact = $datajson['data'][0] ?? [];
    
    

    
//     $step = $datajson['data'][0]['Verification_Step'] ?? null;
    
  
    
//   switch ($step) {
//     case '1':
//         session(['kyc_step' => 1]);
//         return redirect()->route('pancardpage');

//     case '2':
//         session(['kyc_step' => 2]);
//         return redirect()->route('aadharpage');

//     case '3':
//         session(['kyc_step' => 3]);
//         return redirect()->route('aadharkycpage2');

//     case '4':
//         session(['kyc_step' => 4]);
//         return redirect()->route('bankdetailpage');

//     case '5':
//         session(['kyc_step' => 5]);
//         return redirect()->route('webcampage');
        
//     case '6':
//         session(['kyc_step' => 6]);
//         return redirect()->route('nomineepage');
        
//     case '7':
//         session(['kyc_step' => 7]);
//         return redirect()->route('dashboard');

//     default:
//         session(['kyc_step' => 0]);
//         return redirect()->route('userdetailspage');
// }


       
//   }

  public function submitpasscode(Request $request)
   {

  
     $request->validate([
        'otp' => 'required|size:4',
       
    ]);

   
    $enteredPasscode = implode('', $request->otp);
    $userId = session('login_user_id');

     if (!$userId) {
        return redirect()->route('login')
            ->with('error', 'Session expired. Please login again.');
    }
     
    $user = User::find($userId);
    
    $email = $user->email;
    $phone = $user->mobile;
    
    

    if (!$user || !Hash::check($enteredPasscode, $user->passcode)) {
        return redirect()
            ->route('passcodepageenter')
            ->withErrors(['passcode' => 'Incorrect passcode']);
    }
    
    if (empty($user->contactzohoid)) {

     $criteria = $email ? "email=$email" : "phone=$phone";
    $leadResponse = $this->searchRecords('Leads', $criteria);
    $leadResponse = json_decode($leadResponse, true);

    if (!empty($leadResponse['data'])) {

        $leadId = $leadResponse['data'][0]['id'] ?? null;

        if ($leadId) {

            $convertResponse = $this->convertleadintocontact("Leads", $leadId);
            $convertResponse = json_decode($convertResponse, true);

            if (
                isset($convertResponse['data'][0]['code']) &&
                $convertResponse['data'][0]['code'] === 'SUCCESS'
            ) {

                $contactId = $convertResponse['data'][0]['details']['Contacts']['id'] ?? null;

                if ($contactId) {

                    $user->update([
                        'contactzohoid' => $contactId
                    ]);

                    // Optional: create deal
                    $this->createdeal(
                        $contactId,
                        $user->firstname ?? '',
                        $user->lastname ?? ''
                    );

                    // refresh user instance
                    $user->refresh();
                }
            } else {
                return back()->with('error', 'Lead conversion failed.');
            }
        }
    } else {
        return back()->with('error', 'No Contact or Lead found in Zoho.');
    }
}
    

    auth()->login($user);
    session()->regenerate();
    session()->forget('login_user_id');
    
    $data = $this->searchRecordsbyrecordid('Contacts', $user->contactzohoid);
    
    $datajson = json_decode($data, true); // ðŸ‘ˆ decode as array
    
    $zohoContact = $datajson['data'][0] ?? [];
    
    

    
    $step = $datajson['data'][0]['Verification_Step'] ?? null;
    
  
    
   switch ($step) {
    case '1':
        session(['kyc_step' => 1]);
        return redirect()->route('pancardpage');

    case '2':
        session(['kyc_step' => 2]);
        return redirect()->route('aadharpage');

    case '3':
        session(['kyc_step' => 3]);
        return redirect()->route('aadharkycpage2');

    case '4':
        session(['kyc_step' => 4]);
        return redirect()->route('bankdetailpage');

    case '5':
        session(['kyc_step' => 5]);
        return redirect()->route('webcampage');
        
    case '6':
        session(['kyc_step' => 6]);
        return redirect()->route('nomineepage');
        
    case '7':
        session(['kyc_step' => 7]);
        return redirect()->route('dashboard');

    default:
        session(['kyc_step' => 0]);
        return redirect()->route('userdetailspage');
}


       
   }
   
   
   public function createdeal($contactid ,$firstname , $lastname ){
    
    

    $data = [
        'data' => [[
            'Deal_Name' => 'KYC -'.$firstname.''.$lastname,
            'Stage' =>   'Basic Details',
            'Contactid' => $contactid,
            'Pipeline'     => 'KYC',
            'Type'     => 'KYC',
           
            
        ]]
    ];

    return $this->createZohoCrmRecord('Deals', $data);

}
  
  public function forgetpasscodepage()
{
    $userId = session('login_user_id');

    if (!$userId) {
        return redirect()->route('login')
            ->with('error', 'Session expired. Please login again.');
    }

    $user = User::find($userId);

    if (!$user) {
        return redirect()->route('login')
            ->with('error', 'User not found.');
    }

    return view('forgetpasscode_otp', [
        'email'  => $user->email,
        'mobile' => $user->mobile,
    ]);
}



public function forgetpasscode()
{
    $userId = session('login_user_id');

    if (!$userId) {
        return redirect()->route('login')
            ->with('error', 'Session expired. Please login again.');
    }

    $user = User::find($userId);

    if (!$user) {
        return redirect()->route('login')
            ->with('error', 'User not found.');
    }

    // Generate OTPs
    $otpSms   = rand(100000, 999999);
    $otpEmail = rand(100000, 999999);
    $expiryMinutes = 5;

    // Save OTPs
    $user->update([
        'otp_sms'             => $otpSms,
        'otp_email'           => $otpEmail,
        'smsotp_created_at'   => now(),
        'emailotp_created_at' => now(),
    ]);

    $emailSent = false;
    $smsSent   = false;

   
    if (!empty($user->email)) {
        try {
            Mail::to($user->email)->send(
                new EmailOtpMail($otpEmail, $user->first_name)
            );
            $emailSent = true;
        } catch (\Exception $e) {
            Log::error('Email OTP failed', ['error' => $e->getMessage()]);
        }
    }


    if (!empty($user->mobile)) {
        try {
           //$message="Thank you for signing up with BeniSS.â€‹ Your OTP is {$otpSms}.â€‹ Valid for {$expiryMinutes} minutes.Shree Vishnupriya Finance & Leasing Ltd.";
$message = "BeniSS Global Ltd: Use {$otpSms} to reset your password.​OTP valid for {$expiryMinutes} minutes.​Never share your OTP with anyone.";
            $response = Http::get('https://sms.ringinginfotech.in/V2/http-api.php', [
                'apikey'   => config('services.sms.apikey'),
                'senderid' => config('services.sms.senderid'),
                'number'   => $user->mobile,
                'message'  => $message,
                'format'   => 'json',
            ]);

           if (isset($response['status']) ||$response['status'] == 'OK') {
                $smsSent = true;
            }
        } catch (\Exception $e) {
            Log::error('SMS OTP failed', ['error' => $e->getMessage()]);
        }
    }
  

   if ($emailSent && $smsSent) {
        return redirect()->route('forgetpasscodepage');
    }
    
     

   return redirect()->route('passcodepage')
    ->with('error', 'Unable to send OTP to both email and mobile. Please try again.');

    
   
}

public function verifyotp(Request $request)
    {
        $request->validate([
            'email_otp' => 'required|array|size:6',
            'sms_otp' => 'required|array|size:6',
           // 'sms_otp.*' => 'required|numeric'
        ]);
        
       $otpemail = implode('', $request->email_otp);
       $otpsms   = implode('', $request->sms_otp);

        $result = $this->userService->verifyOtpforget($otpsms , $otpemail);
     
       if (! $result['success']) {
        return back()
            ->withInput()
            ->withErrors([
                'otp_error' => $result['message'],
            ]);
    }

        return redirect()->route('updatepasscodepage');
    }
    
      public function updatepasscodepage()
    {
        return view('updatepasscodepage');
    }
    
    
    public function updatepasscode(Request $request)
    {
        
        $request->validate([
            'otp' => 'required|array|size:4',
             'otp.*' => 'nullable|numeric',
       ], [
    'otp.required' => 'Please enter your 4-digit passcode.',
    'otp.size'     => 'Passcode must be exactly 4 digits.',
]);

 $passcodeArray = $request->otp ?? [];

    if (count(array_filter($passcodeArray, 'strlen')) !== 4) {
        return back()->withErrors([
            'otp' => 'Please enter your complete 4-digit passcode.'
        ]);
    }

    $passcode = implode('', $passcodeArray);

        //$passcode = implode('', $request->otp);

        $result = $this->userService->updatepasscode($passcode);

        if (!$result['success']) {
            return back()->withErrors([
                'passcode' => $result['message']
            ]);
        }

        return redirect()->route('login');

    
    }
    
    
    public function resendforgetpasscodeemail()
{
    $userId = session('login_user_id');

    if (!$userId) {
        return response()->json([
            'success' => false,
            'message' => 'Session expired. Please login again.'
        ], 401);
    }

    $user = User::find($userId);

    if (!$user) {
        return response()->json([
            'success' => false,
            'message' => 'User not found.'
        ], 404);
    }

    // Generate Email OTP
    $otpEmail = rand(100000, 999999);

    // Save OTP
    $user->update([
        'otp_email'           => $otpEmail,
        'emailotp_created_at' => now(),
    ]);

    // Send Email OTP
    try {
        if (!empty($user->email)) {
            Mail::to($user->email)->send(
                new EmailOtpMail($otpEmail, $user->first_name)
            );
        }
    } catch (\Exception $e) {
        Log::error('Email OTP failed', [
            'user_id' => $user->id,
            'error'   => $e->getMessage()
        ]);

        return response()->json([
            'success' => false,
            'message' => 'Failed to send email OTP'
        ], 500);
    }

    return response()->json([
        'success' => true,
        'message' => 'Email OTP resent successfully'
    ]);
}



public function resendforgetpasscodesms()
{
    $userId = session('login_user_id');

    if (!$userId) {
        return response()->json([
            'success' => false,
            'message' => 'Session expired. Please login again.'
        ], 401);
    }

    $user = User::find($userId);

    if (!$user) {
        return response()->json([
            'success' => false,
            'message' => 'User not found.'
        ], 404);
    }

    // Generate SMS OTP
    $otpSms = rand(100000, 999999);
    $expiryMinutes = 5;

    // Save OTP
    $user->update([
        'otp_sms'           => $otpSms,
        'smsotp_created_at' => now(),
    ]);

    if (empty($user->mobile)) {
        return response()->json([
            'success' => false,
            'message' => 'Mobile number not available'
        ], 400);
    }

    try {
        //$message="Thank you for signing up with BeniSS.â€‹ Your OTP is {$otpSms}.â€‹ Valid for {$expiryMinutes} minutes.Shree Vishnupriya Finance & Leasing Ltd.";
$message = "BeniSS Global Ltd: Use {$otpSms} to reset your password.​OTP valid for {$expiryMinutes} minutes.​Never share your OTP with anyone.";
        $response = Http::get('https://sms.ringinginfotech.in/V2/http-api.php', [
            'apikey'   => config('services.sms.apikey'),
            'senderid' => config('services.sms.senderid'),
            'number'   => $user->mobile,
            'message'  => $message,
            'format'   => 'json',
        ]);

        $result = $response->json();

        // Adjust condition based on provider response
        if (!isset($result['status']) || $result['status'] !== 'OK') {
            Log::error('SMS API error', ['response' => $result]);

            return response()->json([
                'success' => false,
                'message' => 'Failed to send SMS OTP'
            ], 500);
        }

    } catch (\Exception $e) {
        Log::error('SMS OTP failed', ['error' => $e->getMessage()]);

        return response()->json([
            'success' => false,
            'message' => 'SMS service error'
        ], 500);
    }

    return response()->json([
        'success' => true,
        'message' => 'SMS OTP resent successfully'
    ]);
}










}
