<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CashFlowStatements extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'cash_flow_statements';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'financial_year',
        'profit_before_tax',
        'depreciation',
        'assets_written_off',
        'income_tax_adjustment',
        'operating_profit',
        'receivables_change',
        'inventories_change',
        'current_liabilities_change',
        'short_term_borrowings_change',
        'trade_payables_change',
        'cash_from_operations',
        'net_cash_operating',
        'property_plant_equipment',
        'investment_income',
        'net_cash_investing',
        'long_term_borrowings_payment',
        'net_cash_financing',
        'net_cash_change',
        'cash_beginning',
        'cash_ending',
        'created_at',
    ];

    // Casts
    protected $casts = [
        'company_info_id'                  => 'integer',
        'profit_before_tax'                => 'decimal:2',
        'depreciation'                     => 'decimal:2',
        'assets_written_off'               => 'decimal:2',
        'income_tax_adjustment'            => 'decimal:2',
        'operating_profit'                 => 'decimal:2',
        'receivables_change'               => 'decimal:2',
        'inventories_change'               => 'decimal:2',
        'current_liabilities_change'       => 'decimal:2',
        'short_term_borrowings_change'     => 'decimal:2',
        'trade_payables_change'            => 'decimal:2',
        'cash_from_operations'             => 'decimal:2',
        'net_cash_operating'               => 'decimal:2',
        'property_plant_equipment'         => 'decimal:2',
        'investment_income'                => 'decimal:2',
        'net_cash_investing'               => 'decimal:2',
        'long_term_borrowings_payment'     => 'decimal:2',
        'net_cash_financing'               => 'decimal:2',
        'net_cash_change'                  => 'decimal:2',
        'cash_beginning'                   => 'decimal:2',
        'cash_ending'                      => 'decimal:2',
        'created_at'                       => 'datetime',
    ];

    // Relationship
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGerenalInfo::class, 'company_info_id');
    }
}
