<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyDirectorRemuneration extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'directors_remuneration';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'director_name',
        'year_2023',
        'year_2024',
        'year_2025',
        'created_at',
    ];

    // Casts
    protected $casts = [
        'company_info_id' => 'integer',
        'year_2023'       => 'decimal:2',
        'year_2024'       => 'decimal:2',
        'year_2025'       => 'decimal:2',
        'created_at'      => 'datetime',
    ];

    // Relationship
    public function companyInfo()
    {
        return $this->belongsTo(CompanyGeneralInfo::class, 'company_info_id');
    }
}
