<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OfferParticular extends Model
{
    protected $table = 'offer_particulars';

    protected $fillable = [
        'company_info_id',
        'board_resolution_date',
        'general_meeting_date',
        'securities_class_kind',
        'number_of_equity_shares',
        'face_value',
        'premium',
        'issue_price',
        'price_justification',
        'valuer_name',
        'valuer_address',
        'valuer_report',
        'relevant_date',
        'allotment_proposed_to',
        'promoters_intention',
        'proposed_allotment_time',
        'control_change_details',
        'previous_allotments_details',
        'non_cash_allotment_justification',
        'amount_to_raise',
        'security_type',
        'duration',
        'dividend',
        'interest_rate',
        'payment_repayment_mode',
        'offer_validity_period',
        'offer_purpose',
        'promoters_contribution',
        'assets_security_terms',
        'regulatory_orders_details',
    ];

    protected $casts = [
        'board_resolution_date' => 'date',
        'general_meeting_date'  => 'date',
        'relevant_date'         => 'date',
        'face_value'            => 'decimal:2',
        'premium'               => 'decimal:2',
        'issue_price'           => 'decimal:2',
        'amount_to_raise'       => 'decimal:2',
    ];

    public $timestamps = false;

    /**
     * Relation: Offer belongs to Company
     */
    public function company()
    {
        return $this->belongsTo(
            CompanyGeneralInfo::class,
            'company_info_id',
            'id'
        );
    }
}
