<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProfitTaxProvision extends Model
{
    use HasFactory;

    // Table name
    protected $table = 'profits_tax_provision';

    // Primary key
    protected $primaryKey = 'id';

    // Only created_at exists
    public $timestamps = false;

    // Mass assignable fields
    protected $fillable = [
        'company_info_id',
        'financial_year',
        'profit_before_tax',
        'profit_after_tax',
        'created_at',
    ];

    // Casts
    protected $casts = [
        'company_info_id'    => 'integer',
        'profit_before_tax'  => 'decimal:2',
        'profit_after_tax'   => 'decimal:2',
        'created_at'         => 'datetime',
    ];

    // Relationship
    public function companyInfo()
    {
        return $this->belongsTo(CompanyInfo::class, 'company_info_id');
    }
}
