<?php

namespace App\Services;

use App\Repositories\UserRepository;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use App\Mail\EmailOtpMail;
use Illuminate\Support\Facades\Hash;

class UserService
{
    protected $userRepo;

    public function __construct(UserRepository $userRepo)
    {
        $this->userRepo = $userRepo;
    }

    // Fetch all users
    public function getAllUsers()
    {
        return $this->userRepo->all();
    }

    // Fetch a single user by ID
    public function getUserById(int $id)
    {
        return $this->userRepo->find($id);
    }

    // Create a new user
    public function createUser(array $data)
    {
        // You can add extra logic here, like hashing passwords
        if (isset($data['password'])) {
            $data['password'] = bcrypt($data['password']);
        }
        return $this->userRepo->create($data);
    }

    // Update a user
    public function updateUser(int $id, array $data)
    {
        if (isset($data['password'])) {
            $data['password'] = bcrypt($data['password']);
        }
        return $this->userRepo->update($id, $data);
    }

    // Delete a user
    public function deleteUser(int $id)
    {
        return $this->userRepo->delete($id);
    }

     public function signupWithOtp(array $data): array
    {
        $mobile = $data['mobile'];
        $otp = rand(100000, 999999);
        $expiryMinutes = 5;

        $user = $this->userRepo->findByMobile($mobile);

         if ($user && $user->status == 1) {
        return [
            'success' => false,
            'message' => 'This mobile number is already registered.'
        ];
    }

       if ($user) {
   
        $this->userRepo->updateOtp($user->id, $otp); 
    
       } else {


        $user = $this->userRepo->create([
            'mobile'        => $mobile,
            'referral_code' => $data['referral'] ?? null,
             'otp_sms'           => $otp,
             'smsotp_created_at' => now(),
             'usertype' => $data['usertype']
           
        ]); }

      

       // $message = "Thank you for signing up with BeniSS.​ Your OTP is {$otp}.​ Valid for {$expiryMinutes} minutes.Shree Vishnupriya Finance & Leasing Ltd.";
        $message = "BeniSS Global Ltd: Thank you for signing up with BeniSS. Your OTP is {$otp}. Valid for {$expiryMinutes} minutes.";

        $response = Http::get('https://sms.ringinginfotech.in/V2/http-api.php', [
            'apikey'   => config('services.sms.apikey'),
            'senderid' => config('services.sms.senderid'),
            'number'   => $mobile,
            'message'  => $message,
            'format'   => 'json',
        ]);

        Log::info($response);

       if (
    !isset($response['status']) ||
    $response['status'] !== 'OK'
) {
    return [
        'success' => false,
        'message' => 'Failed to send OTP. Please try again.'
    ];
}


        Session::put('signup_user_id', $user->id);

        return [
            'success' => true
        ];
    } 

    public function verifyOtp(string $otp): array
{
    $userId = session('signup_user_id');
    if (! $userId) {
        return [
            'success' => false,
            'message' => 'Session expired. Please sign up again.'
        ];
    }
    $user = $this->userRepo->find($userId);
    if (! $user || $user->otp_sms !== $otp) {
        return [
            'success' => false,
            'message' => 'Invalid OTP'
        ];
    }

     if (! $user->smsotp_created_at || now()->diffInMinutes($user->smsotp_created_at) > 5) {
        return [
            'success' => false,
            'message' => 'OTP expired. Please resend OTP.'
        ];
    }
   
    return [
        'success' => true
    ];
}


public function sendOtpOnEmail(array $data): array
{
    $userId = session('signup_user_id');

    if (! $userId) {
        return [
            'success' => false,
            'message' => 'Session expired. Please sign up again.'
        ];
    }

    $otp = rand(100000, 999999);
    $user = $this->userRepo->find($userId);

    $userByEmail = $this->userRepo->findByEmail($data['email']);

             if (
            $userByEmail &&
            $userByEmail->status == 1 &&
            $userByEmail->id !== $userId
        ) {
            return [
                'success' => false,
                'message' => 'This email is already registered.'
            ];
        }
    $user->update([
        'first_name'  => $data['firstname'],
         'last_name'  => $data['lastname'],
        'email' => $data['email'],
        'otp_email' => $otp,
        'emailotp_created_at' => now(),
    ]);
    
    $fullname = $data['firstname'] .' '.$data['lastname'];

    // Send email
    Mail::to($data['email'])->send(
        new EmailOtpMail($otp, $fullname)
    );
    Session::put('email_verify_user_id', $user->id);
    return [
        'success' => true
    ];
}

public function verifyEmailOtp(string $otp): array
{
    $userId = session('signup_user_id');
    if (! $userId) {
        return [
            'success' => false,
            'message' => 'Session expired. Please sign up again.'
        ];
    }
    $user = $this->userRepo->find($userId);
    if (! $user || $user->otp_email !== $otp) {
        return [
            'success' => false,
            'message' => 'Invalid OTP'
        ];
    }

     if (! $user->emailotp_created_at || now()->diffInMinutes($user->emailotp_created_at) > 5) {
        return [
            'success' => false,
            'message' => 'OTP expired. Please resend OTP.'
        ];
    }
   
    return [
        'success' => true
    ];
}

public function savePasscode(string $passcode): array
{
    $userId = session('signup_user_id') ?? auth()->id();

    if (! $userId) {
        return [
            'success' => false,
            'message' => 'Session expired. Please login again.'
        ];
    }

    $this->userRepo->updatePasscode(
        $userId,
        Hash::make($passcode)
    );

    // Cleanup signup session
   session()->forget(['signup_user_id']);

    return [
        'success' => true
    ];
}

public function handleGoogleSignup(array $data): array
{
    $email    = $data['email'];
    $googleId = $data['google_id'];
    $name     = $data['name'];

    // User created earlier via mobile OTP
    $signupUserId = session('signup_user_id');

    if (! $signupUserId) {
        return [
            'success' => false,
            'message' => 'Session expired. Please sign up again.'
        ];
    }

    $currentUser = $this->userRepo->find($signupUserId);

    if (! $currentUser) {
        return [
            'success' => false,
            'message' => 'User not found.'
        ];
    }

    // Check if email already exists in DB
    $emailUser = $this->userRepo->findByEmail($email);

    // Case 1: Email already linked with Google
    if ($emailUser && $emailUser->google_id) {
        return [
            'success' => false,
            'message' => 'Email already registered with Google.'
        ];
    }

    // Case 2: Email exists but belongs to another user
    if ($emailUser && $emailUser->id !== $currentUser->id) {
        return [
            'success' => false,
            'message' => 'Email already registered.'
        ];
    }

    // Attach Google + Email to CURRENT signup user
    $otp = rand(100000, 999999);
    
        $fullName = trim($data['name']);
    $nameParts = preg_split('/\s+/', $fullName);
    
    $firstname = $nameParts[0] ?? '';
    $lastname  = count($nameParts) > 1
        ? implode(' ', array_slice($nameParts, 1))
        : '';


    $currentUser->update([
        'first_name'                  => $firstname,
        'last_name' => $lastname,
        'email'                 => $email,
        'google_id'             => $googleId,
        'otp_email'             => $otp,
        'emailotp_created_at'   => now(),
    ]);

    // Send Email OTP
    Mail::to($email)->send(
        new EmailOtpMail($otp, $name)
    );

    Session::put('email_verify_user_id', $currentUser->id);
    Session::put('signup_email', $email);
    Session::put('signup_firstname', $firstname);
     Session::put('signup_lastname', $lastname);

    return [
        'success' => true
    ];
}


public function verifyOtpforget($otpsms , $otpemail): array
{
    $userId = session('login_user_id');

    if (! $userId) {
        return [
            'success' => false,
            'message' => 'Session expired. Please try again.'
        ];
    }

    $user = $this->userRepo->find($userId);

    if (! $user) {
        return [
            'success' => false,
            'message' => 'User not found.'
        ];
    }

    $isEmailOtpValid = false;
    $isSmsOtpValid   = false;

    // ----- Email OTP check -----
    if (
        $user->otp_email == $otpemail &&
        $user->emailotp_created_at &&
        now()->diffInMinutes($user->emailotp_created_at) <= 5
    ) {
        $isEmailOtpValid = true;
    }

    // ----- SMS OTP check -----
    if (
        $user->otp_sms == $otpsms &&
        $user->smsotp_created_at &&
        now()->diffInMinutes($user->smsotp_created_at) <= 5
    ) {
        $isSmsOtpValid = true;
    }

    if (! $isEmailOtpValid && ! $isSmsOtpValid) {
        return [
            'success' => false,
            'message' => 'Invalid or expired OTP.'
        ];
    }

    return [
        'success' => true
    ];
}


public function updatepasscode(string $passcode): array
{
    $userId = session('login_user_id') ;

    if (! $userId) {
        return [
            'success' => false,
            'message' => 'Session expired. Please login again.'
        ];
    }

    $this->userRepo->updatePasscode(
        $userId,
        Hash::make($passcode)
    );

    // Cleanup signup session
    session()->forget(['signup_user_id', 'signup_mobile']);

    return [
        'success' => true
    ];
}



















} 
