<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Otp Verification</title>
  @include('head')
</head>
<body>
@include('header')
  <section class="py-5">
    <div class="container">
        <div class="row g-4 align-items-center">
        <div class="col-lg-6">
            <img src="{{  asset('assets/otp.png')}}" class="img-fluid rounded-4" alt="sign up"/>
        </div>
             <div class="col-lg-5 ms-lg-auto">
                <div class="otp-card">
                    <h3 class="text-center fw-bold mb-3">OTP Verification</h3>
                    <p class="text-12 mb-1">OTP Sent on <strong>{{ $email }}</strong>
                        <a href="{{ route('signup.edit.email') }}" class="edit-link">Edit Email <i class="fa fa-pencil"></i></a>
                    </p>

                    <p class="text-12 text-secondary mb-4">
                        Enter the OTP received as text message on the mobile number.
                    </p>

                     @if ($errors->any())
    <div style="color:red">
        @foreach ($errors->all() as $error)
            <p>{{ $error }}</p>
        @endforeach
    </div>
@endif
                    <form action="{{ route('verifyemailotp') }}" method="POST">
                      @csrf
                        <div class="d-flex justify-content-between mb-4">
                            <input type="text" name="otp[]" maxlength="1" class="otp-input" />
                            <input type="text" name="otp[]" maxlength="1" class="otp-input" />
                            <input type="text" name="otp[]" maxlength="1" class="otp-input" />
                            <input type="text" name="otp[]" maxlength="1" class="otp-input" />
                            <input type="text" name="otp[]" maxlength="1" class="otp-input" />
                            <input type="text" name="otp[]" maxlength="1" class="otp-input" />
                        </div>

                        <button class="btn-submit">Submit</button>
                        <p class="text-12 mt-3">
                            Didn't receive OTP?
                             <a href="javascript:void(0)" id="resendSms"  class="resend-link">Resend via Email</a>
                              <span id="smsTimer" class="text-muted"></span>
                        </p>
                    </form>

                </div>
            </div>
        </div>
    </div>
</section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Simple toggle for User / Partner (visual only) -->
  <script>
    const tabs = document.querySelectorAll(".signup-tab");
    tabs.forEach(tab => {
      tab.addEventListener("click", () => {
        tabs.forEach(t => t.classList.remove("active"));
        tab.classList.add("active");
        // Here you can add logic to change form fields based on selection
      });
    });
  </script>

  <script>
    const otpInputs = document.querySelectorAll('.otp-input');

    otpInputs.forEach((input, index) => {

        input.addEventListener('input', () => {
            // Allow only numbers
            input.value = input.value.replace(/[^0-9]/g, '');

            // Move to next input
            if (input.value && index < otpInputs.length - 1) {
                otpInputs[index + 1].focus();
            }
        });

        input.addEventListener('keydown', (e) => {
            // Backspace → move to previous
            if (e.key === 'Backspace' && !input.value && index > 0) {
                otpInputs[index - 1].focus();
            }
        });

    });
</script>

<script>
const resendBtn = document.getElementById('resendSms');
const timerText = document.getElementById('smsTimer');

let seconds = 60;

// 🔒 Disable immediately on page load
resendBtn.style.pointerEvents = 'none';
resendBtn.style.opacity = '0.5';

const interval = setInterval(() => {
    timerText.innerText = ` (${seconds}s)`;
    seconds--;

    if (seconds < 0) {
        clearInterval(interval);
        timerText.innerText = '';
        resendBtn.style.pointerEvents = 'auto';
        resendBtn.style.opacity = '1';
    }
}, 1000);

// ✅ Call backend ONLY when clickable
resendBtn.addEventListener('click', function () {

    resendBtn.style.pointerEvents = 'none';
    resendBtn.style.opacity = '0.5';

    fetch("{{ route('resend.email.otp') }}", {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": "{{ csrf_token() }}",
            "Accept": "application/json"
        }
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            // restart timer after resend
            seconds = 60;
            timerText.innerText = ` (${seconds}s)`;

            const again = setInterval(() => {
                seconds--;
                timerText.innerText = ` (${seconds}s)`;

                if (seconds < 0) {
                    clearInterval(again);
                    timerText.innerText = '';
                    resendBtn.style.pointerEvents = 'auto';
                    resendBtn.style.opacity = '1';
                }
            }, 1000);
        }
    });
});
</script>

</body>
</html>
