


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>BeniSS Global</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        .offcanvas {
            width: 320px;
        }

        #profileSidebar {
        width: 320px;
    }

    #profileSidebar .list-group-item:hover {
        background-color: #f1f3f5;
    }

    #profileSidebar i {
        color: #111;
    }

   #notification-list .list-group-item:hover {
    background-color: #f9fafb;
}

#notification-list .bg-light {
    background-color: #fff7e6 !important;
    border-left: 4px solid #f59e0b;
}

.offcanvas {
    width: 380px;
}

        @media (max-width: 576px) {
            .offcanvas {
                width: 100%;
            }

            #profileSidebar {
            width: 100%;
        }
        }

        .list-group-item:hover {
            background-color: #FFF7E6;
        }
    </style>
</head>



<body>
  <!-- Main navbar -->
 <nav class="navbar navbar-expand-lg bg-white shadow-sm">
     <div class="container">
         <a class="navbar-brand d-flex align-items-center" href="index.php" style="width: 10%;">
             <img src="{{asset('assets/Beniss_Global.png')}}" alt="BeniSS Logo" class="me-2" style="width: 100%;"/>
         </a>

         <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar"
             aria-controls="mainNavbar" aria-expanded="false" aria-label="Toggle navigation">
             <span class="navbar-toggler-icon"></span>
         </button>
         

      <div class="collapse navbar-collapse" id="mainNavbar">
          
        
        <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
         <li class="nav-item">
    <a class="nav-link {{ request()->routeIs('dashboard') ? 'active fw-semibold' : '' }}"
       href="{{ route('dashboard') }}">
        Home
    </a>
</li>

<li class="nav-item">
    <a class="nav-link {{ request()->routeIs('investment.request') ? 'active fw-semibold' : '' }}"
       href="{{ route('investment.request') }}">
        Requests
    </a>
</li>

<li class="nav-item">
    <a class="nav-link {{ request()->routeIs('transaction.details') ? 'active fw-semibold' : '' }}"
       href="{{ route('transaction.details') }}">
        Statement
    </a>
</li>
         
        </ul>

        <div class="d-flex align-items-center user-link">
                 <!--<svg xmlns="http://www.w3.org/2000/svg" width="39" height="39" viewBox="0 0 39 39" fill="none">-->
                 <!--    <path-->
                 <!--        d="M19.2 2.4C28.4634 2.4 36 9.9366 36 19.2C36 28.4634 28.4634 36 19.2 36C9.9366 36 2.4 28.4634 2.4 19.2C2.4 9.9366 9.9366 2.4 19.2 2.4ZM19.2 0C8.5962 0 0 8.5962 0 19.2C0 29.8038 8.5962 38.4 19.2 38.4C29.8038 38.4 38.4 29.8038 38.4 19.2C38.4 8.5962 29.8038 0 19.2 0Z"-->
                 <!--        fill="#FBEC9A" />-->
                 <!--    <path-->
                 <!--        d="M19.2004 36C9.93699 36 2.40039 28.4634 2.40039 19.2C2.40039 9.93662 9.93699 2.40002 19.2004 2.40002C28.4638 2.40002 36.0004 9.93662 36.0004 19.2C36.0004 28.4634 28.4638 36 19.2004 36Z"-->
                 <!--        fill="#FACB1B" />-->
                 <!--    <path-->
                 <!--        d="M19.2004 2.40002C9.93699 2.40002 2.40039 9.93662 2.40039 19.2C2.40039 23.9676 4.40019 28.2744 7.60059 31.335L31.3354 7.60022C28.2748 4.39922 23.968 2.40002 19.2004 2.40002Z"-->
                 <!--        fill="#FBE158" />-->
                 <!--    <path-->
                 <!--        d="M2.4 19.2C2.4 9.9366 9.9366 2.4 19.2 2.4C23.955 2.4 28.2516 4.389 31.311 7.575L33.0138 5.8722C29.5218 2.2542 24.6252 0 19.2 0C8.5962 0 0 8.5962 0 19.2C0 24.6252 2.2542 29.5218 5.8722 33.0132L7.575 31.3104C4.389 28.2516 2.4 23.955 2.4 19.2Z"-->
                 <!--        fill="#FCF6C2" />-->
                 <!--    <path-->
                 <!--        d="M11.2002 12.3656L11.4636 10.2H17.5874C19.7033 10.2 21.2485 10.3231 22.223 10.5694C23.18 10.8242 23.8648 11.1256 24.2775 11.4738C25.1993 12.2382 25.6602 13.4144 25.6602 15.0025C25.6602 16.183 25.0018 17.304 23.6848 18.3656C25.3617 19.1808 26.2002 20.701 26.2002 22.9261C26.2002 24.667 25.6076 25.9622 24.4223 26.8114C23.2458 27.6522 21.4899 28.115 19.1545 28.2H11.4636L11.2002 26.0343C11.4372 25.7371 11.9333 25.4484 12.6883 25.1681V13.2445C11.9421 12.9898 11.446 12.6968 11.2002 12.3656ZM17.9693 13.0407H16.5733V17.5503H18.7726C19.6945 17.5503 20.3969 17.3252 20.8797 16.8751C21.3714 16.425 21.6172 15.873 21.6172 15.2191C21.6172 14.5651 21.446 14.0726 21.1036 13.7414C20.7612 13.4101 20.3617 13.2106 19.9052 13.1426C19.4574 13.0747 18.8121 13.0407 17.9693 13.0407ZM18.9702 20.4038H16.5733V25.3592H18.4302C19.6506 25.3592 20.5725 25.1851 21.1958 24.8369C21.8279 24.4802 22.144 23.8518 22.144 22.9515C22.144 22.0428 21.8982 21.3932 21.4065 21.0025C20.9149 20.6033 20.1027 20.4038 18.9702 20.4038Z"-->
                 <!--        fill="#A51E21" />-->
                 <!--</svg>-->
                <a href="javascript:void(0)"
   data-bs-toggle="offcanvas"
   data-bs-target="#notificationSidebar"
   aria-controls="notificationSidebar"
   class="me-3 position-relative">

   <i class='far fa-bell'></i>

    <span id="notification-count"
          class="badge bg-danger position-absolute top-0 start-100 translate-middle"
          style="display:none; font-size:10px;">
    </span>
</a>
                   <!-- Profile Icon (opens sidebar) -->
                <a href="javascript:void(0)"
                   data-bs-toggle="offcanvas"
                   data-bs-target="#profileSidebar"
                   aria-controls="profileSidebar"
                   style="cursor:pointer;">

                   <!--<svg xmlns="http://www.w3.org/2000/svg" width="38" height="38" viewBox="0 0 38 38" fill="none">-->
                   <!--      <g clip-path="url(#clip0_1218_1952)">-->
                   <!--          <rect width="38" height="38" rx="19" fill="#FFF2D9" />-->
                   <!--          <rect x="10" y="5.5" width="18" height="18" rx="9" fill="#E79901" />-->
                   <!--          <rect x="-1" y="27.5" width="40" height="40" rx="20" fill="#E79901" />-->
                   <!--      </g>-->
                   <!--      <rect x="0.5" y="0.5" width="37" height="37" rx="18.5" stroke="#FFEAC0" />-->
                   <!--      <defs>-->
                   <!--          <clipPath id="clip0_1218_1952">-->
                   <!--              <rect width="38" height="38" rx="19" fill="white" />-->
                   <!--          </clipPath>-->
                   <!--      </defs>-->
                   <!--  </svg>-->
                     <img id="avatarPreviewCardprofile" src="{{ route('user.avatar') }}" alt="Avatar" class="rounded-circle me-3" width="50" height="50">

                </a>    
             </div>
         </div>
     </div>
 </nav> 


<div class="offcanvas offcanvas-end" tabindex="-1" id="profileSidebar">
    <div class="offcanvas-body d-flex flex-column p-0">

        <!-- CLOSE BUTTON (TOP RIGHT) -->
        <button type="button"
                class="btn-close position-absolute top-0 end-0 m-3"
                data-bs-dismiss="offcanvas"
                aria-label="Close">
        </button>

        <!-- USER INFO -->
        <div class="p-3 d-flex align-items-center border-bottom">
             <img id="avatarPreviewCard" src="{{ route('user.avatar') }}" alt="Avatar" class="rounded-circle me-3" width="50" height="50">
          
            <div>
                <h6 class="mb-0 fw-semibold">{{ auth()->user()->first_name .' '.auth()->user()->last_name }}</h6>
               <small class="text-muted">{{ auth()->user()->email }}</small>
            </div>
        </div>

        <!-- MENU -->
        <div class="px-3 pt-3 text-muted small fw-semibold">
            Menu
        </div>

        <ul class="list-group list-group-flush px-2">

            <li class="list-group-item border-0 rounded-3 my-1">
               <a href="{{route('user-detailspage', ['from' => 'profile'])}}" class="d-flex align-items-center text-decoration-none text-dark">
                    <i class="bi bi-person-circle me-3 fs-5"></i>
                    Profile Details
                </a>
            </li>

            <!--<li class="list-group-item border-0 rounded-3 my-1 bg-light">-->
            <!--    <a href="#" class="d-flex align-items-center text-decoration-none text-dark">-->
            <!--        <i class="bi bi-grid me-3 fs-5"></i>-->
            <!--        <div class="d-flex justify-content-between w-100">-->
            <!--            <span>Balance</span>-->
            <!--            <strong>₹ 0.00</strong>-->
            <!--        </div>-->
            <!--    </a>-->
            <!--</li>-->

            <!-- <li class="list-group-item border-0 rounded-3 my-1">
                <a href="#" class="d-flex align-items-center text-decoration-none text-dark">
                    <i class="bi bi-plus-circle me-3 fs-5"></i>
                    Add Fund Request
                </a>
            </li>

            <li class="list-group-item border-0 rounded-3 my-1">
                <a href="#" class="d-flex align-items-center text-decoration-none text-dark">
                    <i class="bi bi-arrow-down-circle me-3 fs-5"></i>
                    Withdraw Fund Request
                </a>
            </li> -->

            <li class="list-group-item border-0 rounded-3 my-1">
                <a href="{{route('transaction.details')}}" class="d-flex align-items-center text-decoration-none text-dark w-100">
                    <i class="bi bi-file-earmark-text me-3 fs-5"></i>
                    <span class="flex-grow-1">Statement & Report</span>
                  
                </a>
            </li>

            <!--<li class="list-group-item border-0 rounded-3 my-1">-->
            <!--    <a href="#" class="d-flex align-items-center text-decoration-none text-dark">-->
            <!--        <i class="bi bi-gift me-3 fs-5"></i>-->
            <!--        Refer & Earn-->
            <!--    </a>-->
            <!--</li>-->

            <!--<li class="list-group-item border-0 rounded-3 my-1">-->
            <!--    <a href="#" class="d-flex align-items-center text-decoration-none text-dark">-->
            <!--        <i class="bi bi-question-circle me-3 fs-5"></i>-->
            <!--        Help Center-->
            <!--    </a>-->
            <!--</li>-->

            <!--<li class="list-group-item border-0 rounded-3 my-1">-->
            <!--    <a href="#" class="d-flex align-items-center text-decoration-none text-dark">-->
            <!--        <i class="bi bi-gear me-3 fs-5"></i>-->
            <!--        Settings-->
            <!--    </a>-->
            <!--</li>-->

        </ul>

        <!-- FOOTER -->
        <div class="mt-auto p-3 text-center small text-muted">
            You are on v1.1 &nbsp;|&nbsp; Privacy and Policy
        </div>

        <!-- LOGOUT -->
        <div class="p-3">
            <a href="{{route('logout')}}" class="btn btn-dark w-100 d-flex align-items-center justify-content-center gap-2">
                <i class="bi bi-box-arrow-right"></i>
                Log out
            </a>
        </div>

    </div>
</div>


<!-- Notification Sidebar -->
<!--<div class="offcanvas offcanvas-end" tabindex="-1" id="notificationSidebar">-->
<!--    <div class="offcanvas-header" style="background-color:#FFF2D9;">-->
<!--        <h4 class="offcanvas-title">Notifications</h4>-->
<!--        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>-->
<!--    </div>-->

<!--    <div class="offcanvas-body p-0">-->
<!--        <ul id="notification-list" class="list-group list-group-flush">-->
<!--            <li class="list-group-item text-muted">No notifications</li>-->
<!--        </ul>-->
<!--    </div>-->
<!--</div>-->

<div class="offcanvas offcanvas-end shadow-lg" tabindex="-1" id="notificationSidebar">

    <!-- Header -->
    <div class="offcanvas-header border-bottom" style="background: linear-gradient(90deg,#FFF2D9,#FFE8B3);">
        <div>
            <h5 class="mb-0 fw-bold">Notifications</h5>
           
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
    </div>

    <!-- Body -->
    <div class="offcanvas-body p-0" style="max-height: 80vh; overflow-y: auto;">

        <ul id="notification-list" class="list-group list-group-flush">

            <!-- Empty State -->
            <li class="list-group-item text-center py-5 border-0">
                <div class="text-muted">
                    <i class="bi bi-bell" style="font-size: 28px;"></i>
                    <p class="mt-2 mb-0">No notifications yet</p>
                  
                </div>
            </li>

        </ul>

    </div>
</div>

<!-- ================= END SIDEBAR ================= -->


<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function loadNotifications() {
    fetch('/portal/notifications')
        .then(res => res.json())
        .then(data => {

            let badge = document.getElementById('notification-count');
            let list  = document.getElementById('notification-list');

            if (!badge || !list) return;

            // Badge logic (only unread count)
            if (data.count > 0) {
                badge.innerText = data.count;
                badge.style.display = 'inline-block';
            } else {
                badge.style.display = 'none';
            }

            // Render list
            list.innerHTML = '';

            if (data.notifications.length === 0) {
                list.innerHTML = '<li class="list-group-item text-muted">No notifications</li>';
                return;
            }

            data.notifications.forEach(function(notification) {

                let unreadClass = notification.is_read ? '' : 'bg-light';
                list.innerHTML += `
<li class="list-group-item border-0 border-bottom py-3 ${unreadClass}" 
    style="cursor:pointer; transition: background 0.2s;">

    <div class="d-flex justify-content-between align-items-start">
        <div>
            <div class="fw-semibold">${notification.title}</div>
            <div class="small text-muted mt-1">${notification.message}</div>
        </div>
        <small class="text-muted ms-3" style="color:#E79901 !important;">${notification.time_ago}</small>
    </div>

</li>
`;
            });

        })
        .catch(error => console.error(error));
}

document.addEventListener("DOMContentLoaded", function () {

    // Initial load
    loadNotifications();

    // Poll every 5 seconds
    setInterval(loadNotifications, 5000);

    // Mark as read when sidebar opens
    let sidebar = document.getElementById('notificationSidebar');

    if (sidebar) {
        sidebar.addEventListener('shown.bs.offcanvas', function () {

            fetch('/portal/notifications/read', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                }
            })
            .then(res => res.json())
            .then(() => {
                loadNotifications(); // refresh badge
            });

        });
    }

});
</script>
<script>
function previewAvatarCard(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreviewCard').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}

</script>
</body>
</html>