<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>BeniSS Global - Dashboard</title>
    @include('head')
    <style>
    .custom-px {
        padding-left: 5.5rem;
        padding-right: 5.5rem;
    }

    .custom-py {
        padding-top: 2rem;
        padding-bottom: 2rem;
    }

    @media (max-width: 1000px) {

        .custom-px {
            padding-left: 2.5rem;
            padding-right: 2.5rem;
        }

        .WealthCard {
            margin: auto;
        }

        .WealthCardText {
            margin: auto;
        }

        .WealthCardHeading {
            text-align: center;
        }

        .WealthCardButton {
            margin: auto;
        }

        .tab {
            overflow-x: scroll;


        }

        .nav {
            width: max-content;
        }

        .cardHeading {
            padding-top: 8%;
        }




    }

    /* CARD GRADIENT BACKGROUND */
    .invest-card {
        border-radius: 18px;
        position: relative;
        overflow: hidden;
    }

    .invest-card-bg {
        background-image: url('{{asset('assets/frame.png')}}');
       
        /* your image */
        background-repeat: no-repeat;
        background-position: right top;
        background-size: cover;
        border-radius: 1rem;
        /* matches rounded-4 */
        padding-bottom: 0;
        /* footer already handles spacing */
    }


    /* HIGH YIELD RIBBON */
    .high-yield {

        font-weight: 600;
        font-size: 12px;
        padding: 10px 45px;
        border-radius: 0 0 0 14px;
        position: absolute;
        top: 0;
        right: 0;
    }

    /* BBB BADGE */
    .rating-badge {
        background: #ffffff;
        border: 1px solid #e6e6e6;
        font-weight: 600;
        padding: 6px 14px;
    }

    /* STAT BOX */
    .stat-box {
        background: rgba(255, 255, 255, 0.7);
        /* 70% opacity */
        border: 1px solid #e6edf5;
        border-radius: 10px;
        padding: 14px 12px;
        text-align: left;
    }

    /* FOOTER STRIP */
    .card-footer-strip {
        background: #062636;
        color: #ffffff;
        font-size: 13px;
        padding: 12px 104px;
        border-radius: 0 14px 0 0;
        width: fit-content;
    }

    .help-card {
        border-bottom: none
    }


    .help-card::before {
        content: "";
        position: absolute;
        inset: 0;
        padding: 1.5px;
        border-radius: inherit;
        background: linear-gradient(180deg, #E79901 0%, #FFFFFF 100%);
        -webkit-mask:
            linear-gradient(#fff 0 0) content-box,
            linear-gradient(#fff 0 0);

        mask-composite: exclude;
    }
    </style>
</head>

<body>
    @include ('header-dashboard')
    <!-- FIXED DISCOVER SECTION -->
    <section style="background:#062636; z-index:1020;">
        <div class="container pt-4">

            <!-- TITLE -->
            <h3 class="text-white text-center fw-bold mb-4">
                Requests Status
            </h3>

            <!-- INVESTMENT / WITHDRAWAL TOGGLE -->
            <div class="d-flex justify-content-center my-4">
                <div class="btn-group rounded-pill overflow-hidden shadow-sm"
                    style="width: 320px;">
                    <button id="investmentBtn" class="btn fw-semibold text-dark active"
                        style="background-color:#E79901; color:#000; width:50%;" onclick="switchTab('investment')">
                        Investment
                    </button>

                    <button id="withdrawalBtn" class="btn fw-semibold"
                        style="background-color:#fff; color:#000; width:50%;" onclick="switchTab('withdrawal')">
                        Withdrawal
                    </button>
                </div>
            </div>


            <!-- TABS -->
            <div class="tab">
                <ul class="nav nav-tabs border-0 flex-nowrap justify-content-between">

                    <li class="nav-item">
                        <a class="nav-link active bg-white text-dark rounded-top px-3 fw-medium"  href="javascript:void(0)"
       onclick="filterDeals('all')">
                            All
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link text-white px-3 fw-medium"  href="javascript:void(0)"
       onclick="filterDeals('active')">
                            Active
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link text-white px-3 fw-medium"  href="javascript:void(0)"
       onclick="filterDeals('matured')">
                            Matured
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link text-white px-3 fw-medium" href="javascript:void(0)"
       onclick="filterDeals('pending')">
                            Pending
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link text-white px-3 fw-medium"  href="javascript:void(0)"
       onclick="filterDeals('rejected')">
                           Rejected
                        </a>
                    </li>
                </ul>
            </div>

        </div>

    </section>

    <!-- investmentContent  -->
    <div id="investmentContent">
        <div class="container mt-4">
            <!-- rest of page -->

            <!-- SCROLLABLE CONTENT -->
            <div class="container py-4">

            
                
                @forelse($deals as $deal)

@php
    $status = strtolower($deal['Investment_Status']);

    $statusColors = [
        'active'  => '#002233',
        'matured' => '#83FF8E',
        'pending' => '#FFBE55',
        'rejected'  => '#FF9494',
    ];

    $statusColor = $statusColors[$status] ?? '#002233';
@endphp

<div class="card border-0 shadow-sm mb-4 invest-card"  data-status="{{ $status }}">
    <div class="invest-card-bg">

        <!-- STATUS RIBBON -->
        <div class="high-yield text-white" style="background:{{ $statusColor }}">
            {{ ucfirst($status) }}
        </div>

        <!-- HEADER -->
        <div class="cardHeading d-flex justify-content-between align-items-start mb-4"
             style="margin-top:5%; padding-right:8%;">

            <div class="d-flex align-items-center gap-3 px-5">
              <img  src="{{ route('product.photo', $deal['Products']['id']) }}" width="70" />
                <h6 class="fw-bold mb-0">
                    {{ $deal['Products']['name'] }}
                </h6>
            </div>

            <div class="d-flex align-items-center gap-3 px-5">
                <h6 class="fw-bold mb-0">
                  {{ 
    !empty($deal['Closing_Date']) 
        ? \Carbon\Carbon::parse($deal['Closing_Date'])->format('d-m-Y') 
        : ' ' 
}}
                </h6>
            </div>

            <span class="badge rating-badge rounded-pill text-dark fw-bold">
                {{ 'BBB+' }}
            </span>
        </div>

        <!-- STATS -->
        <div class="row g-3 px-5 mb-3">
            <div class="col-md-4">
                <div class="stat-box">
                   <h6 class="fw-bold mb-1">{{ $deal['ROI'] ?? 'NA' }}%</h6>
                    <small class="text-muted">INTEREST</small>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-box">
                    
                     <h6 class="fw-bold mb-1">{{ $deal['Unit'] ?? 0 }} </h6>
                    <small class="text-muted">NUMBER OF SLOTS</small>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-box">
                    <h6 class="fw-bold mb-1">₹ {{ number_format($deal['Investment_Amount'] ?? 0) }}</h6>
                    <small class="text-muted">INVESTED</small>
                </div>
            </div>
        </div>

       <!-- FOOTER STRIP -->
                        <div class="card-footer-strip">
                            Interest Quarterly &nbsp;|&nbsp; Principal At Maturity
                        </div>

    </div>
</div>

@empty
<div class="text-center text-muted py-5">
    No investment requests found.
</div>
@endforelse

<div class="d-flex justify-content-end mt-4">
    {{ $deals->onEachSide(1)->links('pagination::bootstrap-5') }}
</div>

                       

              


           </div>    

        </div>
    </div>
    <!-- withdrawalContent  -->
    <div id="withdrawalContent" style="display:none;">
        <div class="container mt-4">
            <!-- rest of page -->

            <!-- SCROLLABLE CONTENT -->
            <div class="container py-4">

                <!-- INVESTMENT CARD -->
                @forelse($dealswithdraw as $deal)

@php
    $status = strtolower($deal['Investment_Status'] ?? 'active');

    $statusColors = [
        'active'  => '#002233',
        'matured' => '#83FF8E',
        'pending' => '#FFBE55',
        'rejected'  => '#FF9494',
    ];

    $statusColor = $statusColors[$status] ?? '#002233';
@endphp

<div class="card border-0 shadow-sm mb-4 invest-card" data-status="{{ $status }}">
    <div class="invest-card-bg">

        <!-- STATUS -->
        <div class="high-yield text-white" style="background:{{ $statusColor }}">
            {{ ucfirst($status) }}
        </div>

        <!-- HEADER -->
        <div class="cardHeading d-flex justify-content-between align-items-start mb-4"
             style="margin-top:5%; padding-right:8%;">

            <div class="d-flex align-items-center gap-3 px-5">
               <img src="{{ route('product.photo', $deal['Product_Id']) }}" width="70" />
                <h6 class="fw-bold mb-0">
                    {{ $deal['Product_Name'] ?? 'N/A' }}
                </h6>
            </div>

            <div class="d-flex align-items-center gap-3 px-5">
                <h6 class="fw-bold mb-0">
                    {{ 
                        !empty($deal['Created_Time']) 
                        ? \Carbon\Carbon::parse($deal['Created_Time'])->format('d-m-Y') 
                        : '-' 
                    }}
                </h6>
            </div>

            <span class="badge rating-badge rounded-pill text-dark fw-bold">
                BBB+
            </span>
        </div>

        <!-- STATS -->
        <div class="row g-3 px-5 mb-3">
            
             <div class="col-md-4">
                <div class="stat-box">
                    <h6 class="fw-bold mb-1">
                         {{ $deal['Security_Type'] }}
                    </h6>
                    <small class="text-muted">SECURITY TYPE</small>
                    
                </div>
            </div>
            
             <div class="col-md-4">
                <div class="stat-box">
                    <h6 class="fw-bold mb-1">
                        {{ $deal['Withdrawal_Unit'] ?? 0 }}
                    </h6>
                    <small class="text-muted">UNITS</small>
                </div>
            </div>

            <div class="col-md-4">
                <div class="stat-box">
                    <h6 class="fw-bold mb-1">
                        ₹ {{ number_format($deal['Withdrawal_Amount'] ?? 0) }}
                    </h6>
                    <small class="text-muted">WITHDRAWAL AMOUNT</small>
                </div>
            </div>

           

        </div>

        <div class="card-footer-strip">
            Withdrawal Request
        </div>

    </div>
</div>

@empty
<div class="text-center text-muted py-5">
    No withdrawal requests found.
</div>
@endforelse

<div class="d-flex justify-content-end mt-4">
    {{ $dealswithdraw->onEachSide(1)->links('pagination::bootstrap-5') }}
</div>

        
            </div>

        </div>
    </div>



    <footer>
        <img src="{{asset('assets/iso.png')}}">
        <span class="isoText">ISO 27001 Certified</span>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/lottie-web@5.12.2/build/player/lottie.min.js"></script>

    <script>
    function switchTab(type) {
        const investmentBtn = document.getElementById('investmentBtn');
        const withdrawalBtn = document.getElementById('withdrawalBtn');
        const investmentContent = document.getElementById('investmentContent');
        const withdrawalContent = document.getElementById('withdrawalContent');

        if (type === 'investment') {
            investmentBtn.style.backgroundColor = '#E79901';
            withdrawalBtn.style.backgroundColor = '#fff';

            investmentContent.style.display = 'block';
            withdrawalContent.style.display = 'none';
        } else {
            withdrawalBtn.style.backgroundColor = '#E79901';
            investmentBtn.style.backgroundColor = '#fff';

            investmentContent.style.display = 'none';
            withdrawalContent.style.display = 'block';
        }
    }
    </script>
    
    <script>
function filterDeals(status) {
    const cards = document.querySelectorAll('.invest-card');

    cards.forEach(card => {
        const cardStatus = card.getAttribute('data-status');

        if (status === 'all' || cardStatus === status) {
            card.style.display = 'block';
        } else {
            card.style.display = 'none';
        }
    });

    // active tab UI
    document.querySelectorAll('.nav-link').forEach(tab => {
        tab.classList.remove('active', 'bg-white', 'text-dark');
        //tab.classList.add('text-white');
    });

    event.target.classList.add('active', 'bg-white', 'text-dark');
}
</script>

</body>

</html>