<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - User Details</title>
@include('head')
  <style>
      .signup-card{
        padding-top: 0;
      }
  </style>
</head>
<body>
    @if(request('from') === 'profile')
   @include('header-dashboard') 
@else
    @include('header-user') 
@endif



  <section class="hero-section">
    <div class="container">
        <!-- Progress Bar -->
    <!--<div class="text-center mb-2 fw-semibold">20% Completed</div>-->
    <!--<div class="progress-container">-->
    <!--    <div class="progress" style="height: 6px;">-->
    <!--        <div class="progress-bar" style="width: 20%;"></div>-->
    <!--    </div>-->
    <!--</div>-->

      <div class="row g-4 mt-4">
         <div class="col-lg-4">
             <div class="leftCard">
                <div class="avatar-box" onclick="document.getElementById('avatarInputCard').click();">
                  <img id="avatarPreviewCard" src="{{ route('user.avatar') }}" alt="Avatar">
                    <div class="cam-icon">📷</div>

                    <!-- Hidden File Input -->
                    <input type="file" id="avatarInputCard" accept="image/*" style="display:none" onchange="previewAvatarCard(event)">
                </div>
                <p class="accId">Account ID : <?php echo $contact['Account_Id'] ?? '' ?></p>
             </div>
         </div>
      <div class="col-lg-8">
          <div class="signup-card">
         
@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('dashboard') }}" method="GET" class="mx-auto">
@csrf




<div class="row g-3 mb-2">
    <div class="col-md-6">
       <input type="text" name="first_name" class="form-control"
value="{{  $contact['First_Name'] ?? '' }}"
placeholder="First Name" readonly>
    </div>
    <div class="col-md-6">
        <input type="text" name="last_name" class="form-control"
value="{{  $contact['Last_Name'] ?? ''}}"
placeholder="Last Name" readonly>

    </div>
</div>

<div class="mb-3">
   <input type="text" name="phone" class="form-control"
value="{{ $contact['Phone'] ?? '' }}"
placeholder="Phone Number" readonly>

</div>

<div class="mb-3">
   <input type="email" name="email" class="form-control"
value="{{ $contact['Email'] ?? '' }}"
placeholder="Email Id" readonly>

</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Gender</label>
<div class="d-flex gap-4">
<label>
<input type="radio" name="gender" value="Male"
{{  $contact['Gender']  == 'Male' ? 'checked' : '' }} disabled>
Male
</label>
<label>
<input type="radio" name="gender" value="Female"
{{ $contact['Gender'] == 'Female' ? 'checked' : '' }} disabled>
Female
</label>
<label>
<input type="radio" name="gender" value="Other"
{{  $contact['Gender']  == 'Other' ? 'checked' : '' }} disabled>
Other
</label>
</div>
</div>



<div class="mb-3 p-3 border rounded">
<label class="form-label">Annual Income</label>
<div class="d-flex gap-4">
@foreach(['10 Cr','25 Lacs - 1 Cr','10 - 25 Lacs','5 - 10 Lacs','1 - 5 Lacs','1 Lacs'] as $i)
<label>
<input type="radio" name="income" value="{{ $i }}"
{{  $contact['Annual_Income'] == $i ? 'checked' : '' }} disabled>
{{ $i }}
</label>
@endforeach

</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Occupation</label>
<div class="d-flex gap-4">
@foreach(['Business','Housewife','Student','Professional','Private Sector','Others'] as $o)
<label><input type="radio" name="Occupation" value="{{ $o }}"
{{  $contact['Occupation']==$o?'checked':'' }} disabled> {{ $o }}</label>
@endforeach
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Preference for running account settlement</label>
<div class="d-flex gap-4">
@foreach(['Monthly','Quarterly','Yearly'] as $s)
<label>
<input type="radio" name="settlement" value="{{ $s }}"
{{ $contact['Preference_for_Running_Account_Settlement'] == $s ? 'checked' : '' }} disabled>
{{ $s }}
</label>
@endforeach


</div>
</div>





@php
    $nominees = old('nominees', $nominees ?? []);
@endphp

@forelse($nominees as $index => $nominee)
<h4>Nominee {{ $index + 1 }}</h4>

<input type="text" class="form-control mb-2"
name="nominees[{{ $index }}][name]"
value="{{ $nominee['name'] ?? '' }}"
placeholder="Nominee's Name" readonly>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control"
name="nominees[{{ $index }}][pan]"
value="{{ $nominee['pan'] ?? '' }}"
placeholder="Nominee's PAN" readonly>
</div>

<div class="col-md-6">
<input type="date" class="form-control"
name="nominees[{{ $index }}][dob]"
value="{{ $nominee['dob'] ?? '' }}"
max="{{ now()->toDateString() }}" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control"
name="nominees[{{ $index }}][mobile]"
value="{{ $nominee['mobile'] ?? '' }}"
placeholder="Nominee's mobile" readonly>
</div>

<div class="col-md-6">
<input type="email" class="form-control"
name="nominees[{{ $index }}][email]"
value="{{ $nominee['email'] ?? '' }}"
placeholder="Nominee's e-mail" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control"
name="nominees[{{ $index }}][relation]"
value="{{ $nominee['relation'] ?? '' }}"
placeholder="The nominee is my" readonly>
</div>

<div class="col-md-6">
<input type="number" class="form-control"
name="nominees[{{ $index }}][share]"
value="{{ $nominee['share'] ?? '' }}"
placeholder="Percentage of share" readonly>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Address</label>

<label>
<input type="radio"
name="nominees[{{ $index }}][same_address]"
value="Yes"
{{ ($nominee['same_address'] ?? '') == 'Yes' ? 'checked' : '' }} readonly>
Yes
</label>

<label>
<input type="radio"
name="nominees[{{ $index }}][same_address]"
value="No"
{{ ($nominee['same_address'] ?? '') == 'No' ? 'checked' : '' }} disabled>
No
</label>
</div>

<hr>
@empty



<h4>Nominee 1</h4>

<input type="text" class="form-control mb-2" name="nominee_name"
value="{{ old('nominee_name') }}" placeholder="Nominee's Name" readonly>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_pan"
value="{{ old('nominee_pan') }}" placeholder="Nominee's PAN" readonly>
</div>
<div class="col-md-6">
<input type="date" class="form-control" name="nominee_dob"
value="{{ old('nominee_dob') }}" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_mobile"
value="{{ old('nominee_mobile') }}" placeholder="Nominee's mobile" readonly>
</div>
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_email"
value="{{ old('nominee_email') }}" placeholder="Nominee's e-mail" readonly>
</div>
</div>

<div class="row g-3 mb-2">
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_relation"
value="{{ old('nominee_relation') }}" placeholder="The nominee is my" readonly>
</div>
<div class="col-md-6">
<input type="text" class="form-control" name="nominee_percentage"
value="{{ old('nominee_percentage') }}" placeholder="Percentage of share" readonly>
</div>
</div>

<div class="mb-3 p-3 border rounded">
<label class="form-label">Address</label>
<label><input type="radio" name="address" value="Yes"
{{ old('address')=='Yes'?'checked':'' }} readonly> Yes</label>
<label><input type="radio" name="address" value="No"
{{ old('address')=='No'?'checked':'' }} readonly> No</label>
</div>

@endforelse




<div class="d-flex justify-content-center gap-4 mt-4">
<button type="submit" class="btn btn-otp mb-2 btn-yellow">Done</button>
</div>

</form>

          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function previewAvatar(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreview').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}

function previewAvatarCard(event) {
    const reader = new FileReader();
    reader.onload = function(){
        document.getElementById('avatarPreviewCard').src = reader.result;
    }
    reader.readAsDataURL(event.target.files[0]);
}
</script>
</body>
</html>
