<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use App\Console\Commands\MakeRepository;
use App\Console\Commands\MakeService;

Artisan::command('make:repo {name}', function ($name) {
    $this->call(MakeRepository::class, ['name' => $name]);
});

Artisan::command('make:service {name}', function ($name) {
    $this->call(MakeService::class, ['name' => $name]);
});


Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');
