<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Nominee</title>
   <?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>
<body>
<?php echo $__env->make('header-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <section class="hero-section">
    <div class="container">
    

      <div class="row g-4 align-items-center">
         <div class="col-lg-2"></div>
      <div class="col-lg-8">

            <div class="stepper mb-4">
              <div class="step complete">
                  <div class="dot">✓</div>
                  <div>PAN Verification</div>
              </div>
              <div class="line active-line"></div>

              <div class="step complete">
                  <div class="dot">✓</div>
                  <div>Aadhar KYC</div>
              </div>
              <div class="line active-line"></div>

              <div class="step">
                  <div class="dot">✓</div>
                  <div>Personal Info</div>
              </div>
              <div class="line active-line"></div>

              <div class="step">
                  <div class="dot">✓</div>
                  <div>Webcame</div>
              </div>
              <div class="line active-line"></div>

              <div class="step">
                  <div class="dot inactive"> <div style="background-color: #f0a100; width: 6px;  height: 6px; border-radius: 50%;"></div></div>
                  <div class="active-text">Add Nominee</div>
              </div>
          </div>

          <div class="signup-card">
            

             <form class=" mx-auto">

          <h3 class="text-center fw-bold mb-3">Add a nominee</h3>
          <p class=" text-secondary text-center mb-4">
           You can add up to 3 nominee(s) to your account. Adding nominees makes it easier to transfer ownership of your investments in case of any unfortunate eventuality.
        </p>

         

         <div id="nomineeWrapper">

    <!-- Nominee Block -->
    <div class="nominee-item position-relative">
        <h3 class="text-center fw-bold mb-3 mt-3">Nominee 1</h3>
        <button type="button" class="btn btn-sm btn-danger deleteNominee position-absolute top-0 end-0 m-2 d-none">
            ✕
        </button>

        <div class="row g-3 mb-2">
            <div class="col-md-12">
                <input type="text" class="form-control" placeholder="Nominee's Name">
            </div>

            <div class="col-md-6">
                <input type="text" class="form-control" placeholder="Nominee's PAN">
            </div>

            <div class="col-md-6">
                <input placeholder="Nominee's date of birth" type="text"  onfocus="(this.type = 'date')" class="form-control" >
            </div>

            <div class="col-md-6">
                <input type="text" class="form-control" placeholder="Nominee's mobile">
            </div>

            <div class="col-md-6">
                <input type="email" class="form-control" placeholder="Nominee's e-mail">
            </div>

            <div class="col-md-6">
                <input type="text" class="form-control" placeholder="The nominee is my">
            </div>

            <div class="col-md-6">
                <input type="number" class="form-control" placeholder="Percentage of share(%)">
            </div>

            <div class="col-md-12">
                <div class="p-3 border rounded">
                    <label class="form-label">Address</label>
                    <div class="d-flex gap-4">
                        <label>As per my registered address</label>
                        <label><input type="radio" name="address_0" class="me-1"> Yes</label>
                        <label><input type="radio" name="address_0" class="me-1"> No</label>
                    </div>
                </div>
            </div>

        </div>
        <hr>
    </div>

</div>

<div class="text-center">
    <button id="addMore" type="button" class="btn btn-otp mb-2">
        Add Another Nominee +
    </button>
</div>

 <div class="col-md-12 d-flex justify-content-center gap-4 mt-4">
                    
    <button type="button" class="btn btn-otp mb-2 btn-yellow">Continue</button>
 </div>


    </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
let nomineeCount = 1;

document.getElementById("addMore").addEventListener("click", function () {
    const wrapper = document.getElementById("nomineeWrapper");
    const firstNominee = document.querySelector(".nominee-item");
    const clone = firstNominee.cloneNode(true);

    nomineeCount++;

    // Update heading
    clone.querySelector("h3").innerText = "Nominee " + nomineeCount;

    // Clear inputs
    clone.querySelectorAll("input").forEach(input => {
        input.value = "";
        if (input.type === "radio") input.checked = false;
    });

    // Update radio name
    clone.querySelectorAll('input[type="radio"]').forEach(radio => {
        radio.name = "address_" + (nomineeCount - 1);
    });

    // Show delete button
    clone.querySelector(".deleteNominee").classList.remove("d-none");

    wrapper.appendChild(clone);
    updateNomineeNumbers();
});

// Delete nominee
document.addEventListener("click", function (e) {
    if (e.target.classList.contains("deleteNominee")) {
        e.target.closest(".nominee-item").remove();
        updateNomineeNumbers();
    }
});

// Re-number nominees after add/delete
function updateNomineeNumbers() {
    const nominees = document.querySelectorAll(".nominee-item");
    nominees.forEach((item, index) => {
        item.querySelector("h3").innerText = "Nominee " + (index + 1);

        item.querySelectorAll('input[type="radio"]').forEach(radio => {
            radio.name = "address_" + index;
        });

        // First nominee delete button hidden
        const deleteBtn = item.querySelector(".deleteNominee");
        deleteBtn.classList.toggle("d-none", index === 0);
    });

    nomineeCount = nominees.length;
}
</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\beniss\beniss\resources\views/nominee.blade.php ENDPATH**/ ?>