<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>BeniSS Global - Transaction Details</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        .horizontal-scroll {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        .horizontal-scroll table {
            min-width: 1200px;
        }
    </style>

    <?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body>

<?php echo $__env->make('header-dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<section class="hero-section">
<div class="container">

<div class="text-center my-4">
    <h5 class="fw-bold text-uppercase mb-1">Statement Summary</h5>
</div>

<!-- INVESTOR DETAILS CARD -->
<div class="row justify-content-center">
<div>
<div class="card shadow-sm border">
<div class="card-body px-4 py-3">

<div class="d-flex py-2 border-bottom">
    <span class="text-secondary fw-medium col-4">Unique Client Code</span>
    <span class="fw-semibold col-8"><?php echo e($contact['Account_Id'] ?? '-'); ?></span>
</div>

<div class="d-flex py-2 border-bottom">
    <span class="text-secondary fw-medium col-4">Client Name</span>
    <span class="fw-semibold col-8">
        <?php echo e(($contact['First_Name'] ?? '') . ' ' . ($contact['Last_Name'] ?? '')); ?>

    </span>
</div>

<div class="d-flex py-2 border-bottom">
    <span class="text-secondary fw-medium col-4">Father Name</span>
    <span class="fw-semibold col-8"><?php echo e($contact['Father_s_Name'] ?? '-'); ?></span>
</div>

<div class="d-flex py-2 border-bottom">
    <span class="text-secondary fw-medium col-4">Status</span>
    <span class="fw-semibold col-8"><?php echo e($contact['Status'] ?? '-'); ?></span>
</div>

<div class="d-flex py-2 border-bottom">
    <span class="text-secondary fw-medium col-4">PAN</span>
    <span class="fw-semibold col-8"><?php echo e($contact['PAN'] ?? '-'); ?></span>
</div>

<!--<div class="d-flex py-2 border-bottom">-->
<!--    <span class="text-secondary fw-medium col-4">Aadhar No.</span>-->
<!--    <span class="fw-semibold col-8"><?php echo e($contact['Aadhar_Number'] ?? '-'); ?></span>-->
<!--</div>-->

<div class="d-flex py-2 border-bottom">
    <span class="text-secondary fw-medium col-4">Aadhar Address</span>
    <span class="fw-semibold col-8"><?php echo e($contact['Aadhaar_Address'] ?? '-'); ?></span>
</div>

<div class="d-flex py-2 border-bottom">
    <span class="text-secondary fw-medium col-4">Report Type</span>
    <span class="fw-semibold col-8"><?php echo e($contact['Report_Type'] ?? '-'); ?></span>
</div>



<div class="d-flex py-2">
    <span class="text-secondary fw-medium col-4">Generated On</span>
    <span class="fw-semibold col-8">
        <?php echo e(now()->format('d/m/Y H:i:s')); ?>

    </span>
</div>

</div>
</div>
</div>
</div>

<!-- FILTER FORM -->
<div class="row justify-content-center mt-4">
<div>
<div class="card shadow-sm border">
<div class="card-body px-4 py-3">

<form method="GET" action="<?php echo e(route('transaction.details')); ?>">
<div class="row align-items-center g-3">
    
    <div class="col-md-3">
    <label class="fw-semibold">Date Range</label>
    <select name="range" class="form-select">
        <option value="">Select</option>
        <option value="today" <?php echo e(request('range')=='today'?'selected':''); ?>>Today</option>
        <option value="this_week" <?php echo e(request('range')=='this_week'?'selected':''); ?>>This Week</option>
        <option value="this_month" <?php echo e(request('range')=='this_month'?'selected':''); ?>>This Month</option>
        <option value="this_quarter" <?php echo e(request('range')=='this_quarter'?'selected':''); ?>>This Quarter</option>
        <option value="this_year" <?php echo e(request('range')=='this_year'?'selected':''); ?>>This Year</option>

        <option value="yesterday" <?php echo e(request('range')=='yesterday'?'selected':''); ?>>Yesterday</option>
        <option value="previous_week" <?php echo e(request('range')=='previous_week'?'selected':''); ?>>Previous Week</option>
        <option value="previous_month" <?php echo e(request('range')=='previous_month'?'selected':''); ?>>Previous Month</option>
        <option value="previous_quarter" <?php echo e(request('range')=='previous_quarter'?'selected':''); ?>>Previous Quarter</option>
        <option value="previous_year" <?php echo e(request('range')=='previous_year'?'selected':''); ?>>Previous Year</option>

    </select>
</div>

<div class="col-md-3">
    <label class="fw-semibold">From Date</label>
    <input type="date" name="from_date" class="form-control"
           value="<?php echo e(request('from_date')); ?>">
</div>

<div class="col-md-3">
    <label class="fw-semibold">To Date</label>
    <input type="date" name="to_date" class="form-control"
           value="<?php echo e(request('to_date')); ?>">
</div>

<div class="col-md-5 d-flex mt-4" style="gap:10px;">
    <button type="submit" class="btn btn-warning fw-semibold w-100">
        Filter
    </button>
    
    <a href="<?php echo e(route('transaction.details')); ?>" 
   class="btn btn-secondary fw-semibold" style="width: -webkit-fill-available;">
   Reset Date
</a>
    
<a href="<?php echo e(route('transaction.statement.pdf', request()->query())); ?>"
   class="btn btn-dark fw-semibold" style="width: -webkit-fill-available;">
   Download PDF
</a>
</div>

</div>
</form>

</div>
</div>
</div>
</div>

<!-- TRANSACTION TABLE -->
<div class="row justify-content-center mt-4">
<div>
<div class="card shadow-sm border">
<div class="card-body px-4 py-3">
<div class="d-flex justify-content-between">
    <h6 class="fw-bold text-uppercase mb-3 d-flex align-items-center">
    Statement
    </h6>
    
<?php if($transactions->hasPages()): ?>
<div>
    <nav class="d-flex justify-content-end">
        <?php echo e($transactions->onEachSide(1)->links('pagination::bootstrap-5')); ?>

    </nav>
</div>
<?php endif; ?>
</div>



<div class="table-responsive horizontal-scroll">
<table class="table table-bordered align-middle text-nowrap">

<thead class="table-light">
<tr>
<th>Transaction Date</th>
<th>Settlement Date</th>
<th>Security Type</th>
<th>Narration</th>
<!--<th>Chq No.</th>-->
<!--<th>Transaction Type</th>-->
<!--<th>Voucher No.</th>-->
<th>Debit (Rs.)</th>
<th>Credit (Rs.)</th>
<th>Balance (Rs.)</th>
</tr>
</thead>

<tbody>
<?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<tr>
<td>
    <?php echo e(!empty($transaction->transaction_date) 
        ? \Carbon\Carbon::parse($transaction->transaction_date)->format('d-m-Y') 
        : '-'); ?>

</td>

<td>
    <?php echo e(!empty($transaction->settlement_date) 
        ? \Carbon\Carbon::parse($transaction->settlement_date)->format('d-m-Y') 
        : '-'); ?>

</td>
<td><?php echo e($transaction->security_type); ?></td>
<td><?php echo e($transaction->narration); ?></td>
<!--<td><?php echo e($transaction->cheque_no); ?></td>-->
<!--<td><?php echo e($transaction->transaction_type); ?></td>-->
<!--<td><?php echo e($transaction->voucher_no); ?></td>-->
<td><?php echo e(number_format($transaction->debit, 2)); ?></td>
<td><?php echo e(number_format($transaction->credit, 2)); ?></td>
<td><?php echo e(number_format($transaction->balance, 2)); ?></td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
<td colspan="10" class="text-center text-muted">
    No transactions found
</td>
</tr>
<?php endif; ?>
</tbody>

</table>

</div>

</div>
</div>
</div>
</div>

</div>
</section>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/transactiondetails.blade.php ENDPATH**/ ?>