<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>BeniSS Global - Investment Form</title>

<style>

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: Arial, Helvetica, sans-serif;
}

body {
    background: #f5f6f8;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    padding: 30px;
}

/* Card */
.form-container {
    background: #ffffff;
    width: 950px;
    max-width: 100%;
    padding: 40px;
    border-radius: 14px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.06);
}

/* Heading */
.form-title {
    text-align: center;
    font-size: 26px;
    font-weight: 600;
    margin-bottom: 6px;
}

.form-subtitle {
    text-align: center;
    font-size: 14px;
    color: #6b7280;
    margin-bottom: 35px;
}

/* Grid Layout */
.form-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 22px 30px;
}

.full-width {
    grid-column: span 2;
}

.form-group {
    display: flex;
    flex-direction: column;
}

label {
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 6px;
    color: #374151;
}

input, select, textarea {
    padding: 11px 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    font-size: 14px;
    background: #ffffff;
    transition: 0.2s ease;
}

input:focus, select:focus, textarea:focus {
    outline: none;
    border-color: #E79901;
    box-shadow: 0 0 0 2px rgba(231, 153, 1, 0.15);
}

input[readonly], textarea[readonly] {
    background: #f3f4f6;
}

/* Radio Section */
.radio-section {
    background: #f9fafb;
    padding: 18px;
    border-radius: 8px;
    border: 1px solid #e5e7eb;
}

.radio-item {
    display: flex;
    align-items: flex-start;
    gap: 10px;
    margin-bottom: 12px;
}

.radio-item input {
    margin-top: 4px;
}

/* Button */
.primary-btn {
    margin-top: 35px;
    width: 100%;
    padding: 13px;
    border: none;
    border-radius: 8px;
    background: #E79901;
    color: white;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
    transition: 0.2s ease;
}

.primary-btn:hover {
    background: #cf8700;
}

/* Responsive */
@media (max-width: 768px) {
    .form-grid {
        grid-template-columns: 1fr;
    }
    .full-width {
        grid-column: span 1;
    }
}

</style>
</head>

<body>

<div class="form-container">

    <div class="form-title">Investment Form</div>
    <div class="form-subtitle">
        Please review and confirm your investment details
    </div>

    <form method="POST" action="<?php echo e(route('investment.attachment')); ?>">
        <?php echo csrf_field(); ?>

        <div class="form-grid">

            <div class="form-group">
                <label>Name</label>
                <input type="text" value="<?php echo e($name); ?>" readonly>
            </div>

            <div class="form-group">
                <label>Father's Name</label>
                <input type="text" value="<?php echo e($fathername); ?>" readonly>
            </div>

            <div class="form-group full-width">
                <label>Complete Address</label>
                <textarea rows="3" readonly><?php echo e($address); ?></textarea>
            </div>

            <div class="form-group">
                <label>Phone Number</label>
                <input type="text" value="<?php echo e($phone); ?>" readonly>
            </div>

            <div class="form-group">
                <label>Email ID</label>
                <input type="email" value="<?php echo e($email); ?>" readonly>
            </div>

            <div class="form-group">
                <label>PAN Number</label>
                <input type="text" value="<?php echo e($pan); ?>" readonly>
            </div>

            <div class="form-group">
                <label>Bank Account Details</label>
                <input type="text" value="<?php echo e($accountnumber); ?>" placeholder="Enter Bank Account Details">
            </div>

            <div class="form-group">
                <label>Security Type</label>
                <select name="security_type" required>
                    <option value="" disabled selected>Select Security Type</option>
                    <option value="NCD">NCD</option>
                    <option value="CCPS">CCPS</option>
                    <option value="NCPS">NCPS</option>
                    <option value="Equity">Equity</option>
                </select>
            </div>

            <!-- Government Approval Section -->
            <div class="form-group full-width">
                <label>Government Approval Requirement</label>

                <div class="radio-section">

                    <div class="radio-item">
                        <input type="radio" name="govt_approval" value="not_required">
                        <span>
                            The applicant is not required to obtain Government approval under FEMA Rules 2019 prior to subscription of shares.
                        </span>
                    </div>

                    <div class="radio-item">
                        <input type="radio" name="govt_approval" value="obtained">
                        <span>
                            The applicant is required to obtain Government approval under FEMA Rules 2019 and the same has been obtained.
                        </span>
                    </div>

                </div>
            </div>

        </div>

        <button type="submit" class="primary-btn">
            Submit Investment
        </button>

    </form>

</div>

</body>
</html><?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/investmentform.blade.php ENDPATH**/ ?>