<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>BeniSS Global - Webcam Verification</title>

    <?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <style>
        .camera-container {
            position: relative;
            width: 100%;
            height: 340px;
            border-radius: 16px;
            overflow: hidden;
            background: #000;
            box-shadow: 0 12px 30px rgba(0,0,0,0.15);
        }

        .camera-container video,
        .camera-container img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .face-overlay {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 200px;
            height: 240px;
            border: 3px solid rgba(255,255,255,0.9);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            pointer-events: none;
        }

        .btncam button {
            min-width: 120px;
            border-radius: 8px;
            font-weight: 600;
        }

        .instructions li {
            margin-bottom: 6px;
        }
    </style>
</head>

<body>
<?php echo $__env->make('header-user', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<section class="hero-section p-0">
    <div class="container">

        <!-- Stepper -->
        <div class="stepper mb-4">
            <div class="step complete">
                <div class="dot">âœ“</div>
                <div>PAN Verification</div>
            </div>
            <div class="line active-line"></div>

            <div class="step complete">
                <div class="dot">âœ“</div>
                <div>Aadhar KYC</div>
            </div>
            <div class="line active-line"></div>

            <div class="step complete">
                <div class="dot">âœ“</div>
                <div>Personal Info</div>
            </div>
            <div class="line active-line"></div>

            <div class="step">
                <div class="dot inactive">
                    <div style="background:#f0a100;width:6px;height:6px;border-radius:50%;"></div>
                </div>
                <div class="active-text">Webcam</div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-8">

                <h3 class="text-center fw-bold mb-3">Webcam Verification</h3>

                <ul class="instructions mt-3">
                    <li>Ensure good lighting and clear visibility.</li>
                    <li>Remove spectacles, caps, or masks.</li>
                    <li>Align your face within the guide.</li>
                </ul>

                <div class="row align-items-center mt-4">

                    <!-- Camera -->
                    <div class="col-md-6">
                        <div class="camera-container">
                            <video id="video" autoplay playsinline muted></video>
                            <img id="previewImage" class="d-none" />
                            <canvas id="canvas" class="d-none"></canvas>
                            <div class="face-overlay"></div>
                        </div>

                        <p class="text-center text-muted small mt-2">
                            Live camera preview
                        </p>
                    </div>

                   
                <!-- Buttons -->
                <div class="d-flex justify-content-between align-items-center mt-5 btncam">
                    <button class="btn btn-outline-secondary" onclick="history.back()">Back</button>

                    <div>
                        <button class="btn btn-outline-secondary d-none" id="retakeBtn">
                            Retake
                        </button>

                        <button class="btn btn-warning" id="captureBtn">
                            Capture
                        </button>

                        <button class="btn btn-success d-none" id="confirmBtn">
                            <span class="btn-text">Confirm & Continue</span>
                             <span class="spinner-border spinner-border-sm d-none ms-2" role="status"></span>
                        </button>
                    </div>
                </div>

            </div>
        </div>

    </div>
</section>

<script>
const video = document.getElementById('video');
const canvas = document.getElementById('canvas');
const previewImage = document.getElementById('previewImage');

const captureBtn = document.getElementById('captureBtn');
const retakeBtn = document.getElementById('retakeBtn');
const confirmBtn = document.getElementById('confirmBtn');

let stream;
let capturedBlob;

// Start camera
async function startCamera() {
    try {
        stream = await navigator.mediaDevices.getUserMedia({
            video: { facingMode: "user" },
            audio: false
        });
        video.srcObject = stream;
    } catch (err) {
        console.error(err);
        alert(err.message);
    }
}

startCamera();

// Capture
captureBtn.onclick = () => {
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    canvas.getContext('2d').drawImage(video, 0, 0);

    canvas.toBlob(blob => {
        capturedBlob = blob;
        previewImage.src = URL.createObjectURL(blob);

        video.classList.add('d-none');
        previewImage.classList.remove('d-none');

        captureBtn.classList.add('d-none');
        retakeBtn.classList.remove('d-none');
        confirmBtn.classList.remove('d-none');

        stream.getTracks().forEach(t => t.stop());
    }, 'image/jpeg', 0.6); // 🔥 reduced size
};

// Retake
retakeBtn.onclick = () => {
    previewImage.classList.add('d-none');
    video.classList.remove('d-none');

    captureBtn.classList.remove('d-none');
    retakeBtn.classList.add('d-none');
    confirmBtn.classList.add('d-none');

    startCamera();
};

// Upload
confirmBtn.onclick = async () => {
    confirmBtn.disabled = true;
    confirmBtn.querySelector('.btn-text').innerText = 'Uploading...';
    confirmBtn.querySelector('.spinner-border').classList.remove('d-none');

    try {
        const formData = new FormData();
        formData.append('photo', capturedBlob);

        const res = await fetch("<?php echo e(route('webcam.upload')); ?>", {
            method: "POST",
            headers: { "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>" },
            body: formData
        });

        const data = await res.json();

        if (!data.success) throw new Error(data.message);

        setTimeout(() => {
           
            window.location.href = "<?php echo e(route('nomineepage')); ?>";
        }, 300);

    } catch (e) {
        alert(e.message);
        confirmBtn.disabled = false;
        confirmBtn.querySelector('.btn-text').innerText = 'Confirm & Continue';
        confirmBtn.querySelector('.spinner-border').classList.add('d-none');
    }
};
</script>


</body>
</html>
<?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/webcam.blade.php ENDPATH**/ ?>