<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Otp Verification For Create new Passcode</title>
  <?php echo $__env->make('head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>
<body>
<?php echo $__env->make('header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<section class="pt-4 pb-2">
  <h3 class="text-center fw-bold mb-3">Otp Verification For Create new Passcode</h3>

  <div class="container">
    <form action="<?php echo e(route('verifyotpforget')); ?>" method="POST">
      <?php echo csrf_field(); ?>

      <div class="row g-4 align-items-center justify-content-evenly">

        <!-- EMAIL OTP -->
        <div class="col-lg-5">
          <div class="otp-card">
            <h3 class="text-center fw-bold mb-3">Email Verification</h3>
            <p class="text-12 mb-1">
              OTP Sent on <strong><?php 
   echo $maskedEmail = preg_replace(
        '/(^.).*(@.*$)/',
        '$1XXXXXXX$2',
        $email
    );
?></strong>
            </p>
            <p class="text-12 text-secondary mb-4">
              Enter the OTP received as text message on the Mail ID.
            </p>

            <div class="d-flex justify-content-between mb-4">
              <input type="text" maxlength="1" name="email_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="email_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="email_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="email_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="email_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="email_otp[]" class="otp-input" />
            </div>

            <p class="text-12 mt-3">
              Didn't receive OTP?
                 <a href="javascript:void(0)" 
   class="resendOtp" 
   data-type="email">
   Resend via Email
</a>
<span class="smsTimer text-muted"></span>

            </p>
          </div>
        </div>

        <hr style="width:15%; rotate:90deg;">

        <!-- MOBILE OTP -->
        <div class="col-lg-5">
          <div class="otp-card">
            <h3 class="text-center fw-bold mb-3">Mobile Verification</h3>
            <p class="text-12 mb-1">
              OTP Sent on <strong><?php 
    echo $maskedMobile = substr($mobile, 0, 2) . 'XXXXXX' . substr($mobile, -2);
?>
</strong>
            </p>
            <p class="text-12 text-secondary mb-4">
              Enter the OTP received as text message on the mobile number.
            </p>

            <div class="d-flex justify-content-between mb-4">
              <input type="text" maxlength="1" name="sms_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="sms_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="sms_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="sms_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="sms_otp[]" class="otp-input" />
              <input type="text" maxlength="1" name="sms_otp[]" class="otp-input" />
            </div>

            <p class="text-12 mt-3">
              Didn't receive OTP?
                 <a href="javascript:void(0)" 
   class="resendOtp" 
   data-type="sms">
   Resend via SMS
</a>
<span class="smsTimer text-muted"></span>

 
            </p>
          </div>
        </div>

      </div>
      
      <?php if($errors->has('otp_error')): ?>
    <div class="alert alert-danger">
        <?php echo e($errors->first('otp_error')); ?>

    </div>
<?php endif; ?>


      <!-- SINGLE SUBMIT BUTTON -->
      <div class="text-center mt-4">
        <button class="btn-submit">Submit</button>
      </div>

    </form>
  </div>
</section>

    <script>
    const otpInputs = document.querySelectorAll('.otp-input');

    otpInputs.forEach((input, index) => {

        input.addEventListener('input', () => {
            // Allow only numbers
            input.value = input.value.replace(/[^0-9]/g, '');

            // Move to next input
            if (input.value && index < otpInputs.length - 1) {
                otpInputs[index + 1].focus();
            }
        });

        input.addEventListener('keydown', (e) => {
            // Backspace → move to previous
            if (e.key === 'Backspace' && !input.value && index > 0) {
                otpInputs[index - 1].focus();
            }
        });

    });
</script>

<script>
document.querySelectorAll('.resendOtp').forEach(btn => {

    const timerText = btn.nextElementSibling;
    const type = btn.dataset.type; // email | sms
    let seconds = 60;
    let interval = null;

    disable();
    startTimer();

    function disable() {
        btn.style.pointerEvents = 'none';
        btn.style.opacity = '0.5';
    }

    function enable() {
        btn.style.pointerEvents = 'auto';
        btn.style.opacity = '1';
    }

    function startTimer() {
        clearInterval(interval);
        interval = setInterval(() => {
            timerText.innerText = ` (${seconds}s)`;
            seconds--;

            if (seconds < 0) {
                clearInterval(interval);
                timerText.innerText = '';
                enable();
            }
        }, 1000);
    }

    btn.addEventListener('click', () => {
        disable();

        const url = type === 'email'
            ? "<?php echo e(route('resendforgetpasscodeemail')); ?>"
            : "<?php echo e(route('resendforgetpasscodesms')); ?>";

        fetch(url, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                'Accept': 'application/json'
            }
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                seconds = 60;
                startTimer();
            } else {
                enable();
                alert(data.message || 'Failed to resend OTP');
            }
        })
        .catch(() => {
            enable();
            alert('Something went wrong. Please try again.');
        });
    });
});
</script>



<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH /home2/heupddmy/public_html/beniss/resources/views/forgetpasscode_otp.blade.php ENDPATH**/ ?>