<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>BeniSS Global - Sign Up</title>
 @include('head')

</head>
<style>
.signup-tab:disabled {
    opacity: 0.5;
    cursor: not-allowed;
    pointer-events: none;
}
</style>

<body>
@include('header')

  <section class="hero-section">
    <div class="container">
      <div class="row g-4 align-items-center">
        <div class="col-lg-6">
           <img src="{{ asset('assets/sign-up.png') }}" class="img-fluid rounded-4" alt="sign up">

        </div>

        <!-- Right side: signup form -->
        <div class="col-lg-5 ms-lg-auto">
          <div class="signup-card">
            <h4 class="mb-4 text-center">Sign Up</h4>
            <!-- Role toggle -->
            


            <form action="{{ route('signupotp') }}" method="POST">
              @csrf
              
              <div class="signup-tabs">
              <button type="button" class="signup-tab active" data-type="Investor">BeniSS User</button>
              <button type="button" class="signup-tab" data-type="Business Partner"disabled>BeniSS Partner</button>
            </div>
            
            <input type="hidden" name="usertype" id="userType" value="Investor">


              @if ($errors->any())
    <div style="color:red">
        @foreach ($errors->all() as $error)
            <p>{{ $error }}</p>
        @endforeach
    </div>
@endif

              <!-- Mobile number -->
              <div class="mb-3">
                <!-- <label class="form-label" for="mobileNumber">Mobile number</label> -->
                <div class="input-group">
                  <span class="input-group-text" style="gap: 5px;"><img class="flag" src="{{asset('assets/flag.png')}}">+91</span>
                  <input type="tel" class="form-control" value="{{ old('mobile') }}" name="mobile" id="mobileNumber" placeholder="Mobile number" required />
                </div>
              </div>

              <!-- Referral Code -->
              <div class="mb-3">
                <!-- <label class="form-label" for="referralCode">Referral Code</label> -->
                <input type="text" class="form-control" value="{{ old('refercode') }}" name="referral" id="referralCode" placeholder="Referral Code (Optional)"/>
              </div>

              <!-- Terms -->
              <div class="mb-3 form-check">
                <input
                  type="checkbox"
                  class="form-check-input"
                  name="privacycheck"
                  id="termsCheck" {{ old('privacycheck') ? 'checked' : '' }}
                />
                <label class="form-check-label small" for="termsCheck">
                  By proceeding, you agree to the
                  <a href="#" class="">BeniSS Global terms</a>
                  &
                  <a href="#" class="">privacy policy</a>.
                </label>
              </div>

              <!-- Get OTP -->
              <button type="submit" class="btn btn-otp mb-2">
                Get OTP
              </button>

              <!-- OR divider -->
              <div class="divider">
                <span>or</span>
              </div>

              <!-- Already have account -->
              <p class="text-center small already-text mb-0">
                Already have an account?
                <a href="{{route('login')}}">Login</a>
              </p>
            </form>
          </div>
        </div>

      </div>
    </div>
  </section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  
  <script>
document.querySelectorAll('.signup-tab').forEach(tab => {
    tab.addEventListener('click', function () {
        
         if (this.disabled) {
            e.preventDefault();
            return;
        }

        // remove active from all
        document.querySelectorAll('.signup-tab').forEach(t => t.classList.remove('active'));

        // add active to clicked
        this.classList.add('active');

        // set hidden input value
        document.getElementById('userType').value = this.dataset.type;
    });
});
</script>

 
</body>
</html>
