<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Otp Verification</title>
  @include('head')
</head>
<body>
@include('header')
  <section class="py-5">
    <div class="container">
        <div class="row g-4 align-items-center">
        <div class="col-lg-6">
            <img src="{{ asset('assets/otp.png') }}" class="img-fluid rounded-4" alt="sign up"/>
        </div>
             <div class="col-lg-5 ms-lg-auto">
                <div class="otp-card text-center">
                    <h3 class="text-center fw-bold mb-3">Create Passcode</h3>
                    
                    {{-- Session error message --}}
@if (session('error'))
    <div class="alert alert-danger text-center mb-3">
        {{ session('error') }}
    </div>
@endif

{{-- Validation errors --}}
@if ($errors->any())
    <div class="alert alert-danger text-center mb-3">
        @foreach ($errors->all() as $error)
            <div>{{ $error }}</div>
        @endforeach
    </div>
@endif

                    <form action="{{ route('createpasscode') }}" method="POST">
                      @csrf
                        <p class="text-12 text-secondary mb-4">
                           Enter the 4 Digits to set passcode.
                        </p>
                        <div class="d-flex mb-4 passcode">
                            <input type="password" name="passcode[]"maxlength="1"class="otp-input" />
                            <input type="password" name="passcode[]" maxlength="1" class="otp-input" />
                            <input type="password" name="passcode[]"maxlength="1" class="otp-input"  />
                            <input type="password" name="passcode[]"maxlength="1" class="otp-input" />
                        </div>

                         <p class="text-12 mb-4">
                          ReConfirm Your Password
                        </p>
                        <div class="d-flex mb-4 passcode">
                            <input type="password" name="passcode_confirmation[]" maxlength="1"class="otp-input confirm" />
                            <input type="password" name="passcode_confirmation[]"maxlength="1" class="otp-input confirm" />
                            <input type="password" name="passcode_confirmation[]"maxlength="1" class="otp-input confirm"  />
                            <input type="password" name="passcode_confirmation[]"maxlength="1" class="otp-input confirm" />
                        </div> 

                        <button class="btn-submit">Submit</button>
                        
                    </form>

                </div>
            </div>
        </div>
    </div>
</section>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Simple toggle for User / Partner (visual only) -->
  <script>
    const tabs = document.querySelectorAll(".signup-tab");
    tabs.forEach(tab => {
      tab.addEventListener("click", () => {
        tabs.forEach(t => t.classList.remove("active"));
        tab.classList.add("active");
        // Here you can add logic to change form fields based on selection
      });
    });
  </script>

    <script>
function setupOtp(inputs) {
    inputs.forEach((input, index) => {

        input.addEventListener('input', () => {
            input.value = input.value.replace(/[^0-9]/g, '');

            if (input.value && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }
        });

        input.addEventListener('keydown', (e) => {
            if (e.key === 'Backspace' && !input.value && index > 0) {
                inputs[index - 1].focus();
            }
        });

    });
}

setupOtp(document.querySelectorAll('.otp-input:not(.confirm)'));
setupOtp(document.querySelectorAll('.otp-input.confirm'));
</script>

</body>
</html>
